/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.recipe;

import java.util.List;
import net.minecraft.core.data.registry.recipe.HasJsonAdapter;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.adapter.RecipeJsonAdapter;
import net.minecraft.core.item.ItemStack;
import teamport.aether.recipe.RecipeEntity;
import teamport.aether.recipe.RecipeIncubatorJsonAdapter;

public class RecipeEntryIncubator
extends RecipeEntryBase<RecipeSymbol, RecipeEntity, Integer>
implements HasJsonAdapter {
    public RecipeEntryIncubator(RecipeSymbol input, RecipeEntity output, int time) {
        super((Object)input, (Object)output, (Object)time);
    }

    public RecipeEntryIncubator() {
    }

    public boolean matchesQueryIgnoreExceptions(SearchQuery query) {
        try {
            return this.matchesQuery(query);
        }
        catch (IllegalArgumentException | NullPointerException var3) {
            return false;
        }
    }

    public boolean matches(ItemStack stack) {
        return ((RecipeSymbol)this.getInput()).matches(stack);
    }

    public boolean matchesQuery(SearchQuery query) {
        switch (query.mode) {
            case ALL: {
                if (!this.matchesRecipe(query) && !this.matchesUsage(query)) break;
                return true;
            }
            case RECIPE: {
                if (!this.matchesRecipe(query)) break;
                return true;
            }
            case USAGE: {
                if (!this.matchesUsage(query)) break;
                return true;
            }
        }
        return false;
    }

    public boolean matchesRecipe(SearchQuery query) {
        if (query.query.getLeft() == SearchQuery.QueryType.NAME) {
            if (query.strict && ((RecipeEntity)this.getOutput()).getEntity().equalsIgnoreCase((String)query.query.getRight())) {
                return true;
            }
            return !query.strict && ((RecipeEntity)this.getOutput()).getEntity().toLowerCase().contains(((String)query.query.getRight()).toLowerCase());
        }
        return false;
    }

    public boolean matchesUsage(SearchQuery query) {
        List stacks = ((RecipeSymbol)this.getInput()).resolve();
        for (ItemStack stack : stacks) {
            if (stack == null || query.query.getLeft() != SearchQuery.QueryType.NAME) continue;
            if (query.strict && stack.getDisplayName().equalsIgnoreCase((String)query.query.getRight())) {
                return true;
            }
            if (query.strict || !stack.getDisplayName().toLowerCase().contains(((String)query.query.getRight()).toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public RecipeJsonAdapter<?> getAdapter() {
        return new RecipeIncubatorJsonAdapter();
    }
}

