/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.feature.dungeon.bronze.component;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.Direction;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.world.feature.dungeon.bronze.component.BaseBronzeRoom;
import teamport.aether.world.feature.util.WorldFeatureComponent;
import teamport.aether.world.feature.util.WorldFeaturePoint;

public class SpikerRoom
extends BaseBronzeRoom {
    public SpikerRoom() {
        this.height = 12;
        this.addDoor(Direction.NORTH, WorldFeaturePoint.wfp(4, 1, 0), Direction.UP, 6, Direction.EAST, 4);
        this.addDoor(Direction.EAST, WorldFeaturePoint.wfp(11, 1, 4), Direction.UP, 6, Direction.SOUTH, 4);
        this.addDoor(Direction.SOUTH, WorldFeaturePoint.wfp(4, 1, 11), Direction.UP, 6, Direction.EAST, 4);
        this.addDoor(Direction.WEST, WorldFeaturePoint.wfp(0, 1, 4), Direction.UP, 6, Direction.SOUTH, 4);
    }

    public void makeShell() {
        this.room.add(WorldFeatureComponent.drawHollowShell(this.random, ROOM_PALLET, Direction.SOUTH, this.width, Direction.UP, this.height, Direction.EAST, this.width, this.x, this.y, this.z, false));
    }

    public void makeSpikePit(int pitHeight) {
        this.room.add(WorldFeatureComponent.drawSquareCylinder(this.random, ROOM_PALLET, Direction.SOUTH, 8, Direction.EAST, 8, Direction.DOWN, pitHeight, this.x + 2, this.y, this.z + 2, false));
        this.room.add(WorldFeatureComponent.drawPlane(this.random, ROOM_PALLET, Direction.SOUTH, 6, Direction.EAST, 6, this.x + 3, this.y - pitHeight + 1, this.z + 3, false));
        this.decoration.add(WorldFeatureComponent.drawPlane(Blocks.SPIKES.id(), 0, Direction.SOUTH, 6, Direction.EAST, 6, this.x + 3, this.y - pitHeight + 2, this.z + 3, false));
    }

    public void makeHangingChest() {
        this.decoration.add(WorldFeatureComponent.drawPlane(AetherBlocks.SLAB_PLANKS_SKYROOT.id(), 2, Direction.SOUTH, 4, Direction.EAST, 4, this.x + 4, this.y + this.height - 7, this.z + 4, false));
        this.chest.add(WorldFeatureComponent.drawPlane(this.random, chestOrMimic, Direction.SOUTH, 2, Direction.EAST, 2, this.x + 5, this.y + this.height - 6, this.z + 5, false));
        this.decoration.add(WorldFeatureComponent.drawPlane(AetherBlocks.FENCE_PLANKS_SKYROOT.id(), 0, Direction.DOWN, 5, Direction.EAST, 1, this.x + 4, this.y + this.height - 2, this.z + 4, true));
        this.decoration.add(WorldFeatureComponent.drawPlane(AetherBlocks.FENCE_PLANKS_SKYROOT.id(), 0, Direction.DOWN, 5, Direction.EAST, 1, this.x + 7, this.y + this.height - 2, this.z + 4, true));
        this.decoration.add(WorldFeatureComponent.drawPlane(AetherBlocks.FENCE_PLANKS_SKYROOT.id(), 0, Direction.DOWN, 5, Direction.EAST, 1, this.x + 7, this.y + this.height - 2, this.z + 7, true));
        this.decoration.add(WorldFeatureComponent.drawPlane(AetherBlocks.FENCE_PLANKS_SKYROOT.id(), 0, Direction.DOWN, 5, Direction.EAST, 1, this.x + 4, this.y + this.height - 2, this.z + 7, true));
    }

    @Override
    public void makeRoom() {
        this.makeShell();
        this.makeSpikePit(this.random.nextBoolean() ? 14 : 4);
        if (this.random.nextInt(3) == 0) {
            this.makeHangingChest();
        }
    }
}

