/*
 * Decompiled with CFR 0.152.
 */
package gungun974.uselessnumerical.mixin;

import gungun974.uselessnumerical.MinecraftIdsConfiguration;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.item.Item;
import net.minecraft.core.util.collection.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Item.class}, remap=false)
public class ItemMixin {
    @Mutable
    @Shadow
    @Final
    public int id;
    @Shadow
    @Final
    public static Item @NotNull [] itemsList;
    @Mutable
    @Shadow
    @Final
    public NamespaceID namespaceID;
    @Shadow
    @Final
    public static Map itemsMap;
    @Shadow
    public static int highestItemId;
    @Unique
    private static final Item[] fakeItemsList;
    @Unique
    private static Map fakeItemsMap;

    @Inject(method={"<init>(Lnet/minecraft/core/util/collection/NamespaceID;I)V"}, at={@At(value="RETURN")})
    private void hijackRegister(NamespaceID namespaceId, int preferredId, CallbackInfo ci) {
        ItemMixin.fakeItemsList[preferredId] = null;
        fakeItemsMap.remove(this.namespaceID);
        this.id = MinecraftIdsConfiguration.getInstance().generateNumericalIdForItem(namespaceId, preferredId);
        if (itemsList[this.id] != null) {
            throw new IllegalArgumentException("Item slot '" + this.id + "' is already occupied by '" + itemsList[this.id] + "' when adding " + this);
        }
        if (itemsMap.containsKey(this.namespaceID)) {
            throw new IllegalArgumentException("Item id '" + this.namespaceID + "' is already used by '" + itemsMap.get(this.namespaceID) + "' when adding " + this);
        }
        ItemMixin.itemsList[this.id] = (Item)this;
        itemsMap.put(this.namespaceID, this);
        if (this.id > highestItemId) {
            highestItemId = this.id;
        }
    }

    @Redirect(method={"<init>(Lnet/minecraft/core/util/collection/NamespaceID;I)V"}, at=@At(value="FIELD", target="Lnet/minecraft/core/item/Item;itemsList:[Lnet/minecraft/core/item/Item;"))
    private Item[] dontTouchItemsList() {
        return fakeItemsList;
    }

    @Redirect(method={"<init>(Lnet/minecraft/core/util/collection/NamespaceID;I)V"}, at=@At(value="FIELD", target="Lnet/minecraft/core/item/Item;itemsMap:Ljava/util/Map;"))
    private Map dontTouchItemsMap() {
        return fakeItemsMap;
    }

    @Redirect(method={"<init>(Lnet/minecraft/core/util/collection/NamespaceID;I)V"}, at=@At(value="FIELD", opcode=179, target="Lnet/minecraft/core/item/Item;highestItemId:I"))
    private void dontTouchHighestItemId(int value) {
    }

    static {
        fakeItemsList = new Item[32768];
        fakeItemsMap = new HashMap();
    }
}

