/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import net.fabricmc.api.ModInitializer;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.data.registry.Registry;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.util.collection.Pair;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.UnmodifiableView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sunsetsatellite.catalyst.core.util.BlockChangeInfo;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.Signal;
import sunsetsatellite.catalyst.core.util.mp.IMpGui;
import sunsetsatellite.catalyst.core.util.mp.MpGuiEntry;
import sunsetsatellite.catalyst.core.util.mp.PacketAddNetworkBlock;
import sunsetsatellite.catalyst.core.util.mp.PacketBlockNetworkData;
import sunsetsatellite.catalyst.core.util.mp.PacketOpenGui;
import sunsetsatellite.catalyst.core.util.mp.PacketRemoveNetworkBlock;
import sunsetsatellite.catalyst.core.util.mp.PacketScreenAction;
import sunsetsatellite.catalyst.core.util.network.NetworkManager;
import sunsetsatellite.catalyst.core.util.section.BlockSection;
import sunsetsatellite.catalyst.core.util.vector.Vec2f;
import turniplabs.halplibe.helper.network.NetworkHandler;

public class Catalyst
implements ModInitializer {
    public static final String MOD_ID = "catalyst-core";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"catalyst-core");
    public static final Registry<MpGuiEntry> GUIS = new Registry();
    public static final Signal<BlockChangeInfo> TILE_ENTITY_BLOCK_CHANGED_SIGNAL = new Signal();
    public static final Signal<BlockChangeInfo> ANY_BLOCK_CHANGED_SIGNAL = new Signal();
    public static final Signal<World> DIMENSION_LOAD_SIGNAL = new Signal();
    public static final Signal<World> DIMENSION_SAVE_SIGNAL = new Signal();

    public void onInitialize() {
        NetworkHandler.registerNetworkMessage(PacketOpenGui::new);
        NetworkHandler.registerNetworkMessage(PacketScreenAction::new);
        NetworkHandler.registerNetworkMessage(PacketBlockNetworkData::new);
        NetworkHandler.registerNetworkMessage(PacketAddNetworkBlock::new);
        NetworkHandler.registerNetworkMessage(PacketRemoveNetworkBlock::new);
        this.connectSignals();
        LOGGER.info("Catalyst: Core initialized.");
    }

    public void connectSignals() {
        TILE_ENTITY_BLOCK_CHANGED_SIGNAL.connect(NetworkManager.BlockChangeListener.INSTANCE);
        DIMENSION_LOAD_SIGNAL.connect(NetworkManager.LoadSaveListener.INSTANCE);
        DIMENSION_SAVE_SIGNAL.connect(NetworkManager.LoadSaveListener.INSTANCE);
    }

    public static <K, V> Map<K, V> mapOf(K[] keys, V[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays differ in size!");
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <T, V> T[] arrayFill(T[] array, V value) {
        Arrays.fill(array, value);
        return array;
    }

    public static double map(double valueCoord, double startCoord1, double endCoord1, double startCoord2, double endCoord2) {
        double EPSILON = 1.0E-12;
        if (Math.abs(endCoord1 - startCoord1) < 1.0E-12) {
            throw new ArithmeticException("Division by 0");
        }
        double ratio = (endCoord2 - startCoord2) / (endCoord1 - startCoord1);
        return ratio * (valueCoord - startCoord1) + startCoord2;
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... values) {
        return new ArrayList<T>(Arrays.asList(values));
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... values) {
        return new HashSet<T>(Arrays.asList(values));
    }

    public static <T, U> List<Pair<T, U>> zip(List<T> first, List<U> second) {
        ArrayList<Pair<T, U>> list = new ArrayList<Pair<T, U>>();
        List<Object> shortest = first.size() < second.size() ? first : second;
        for (int i = 0; i < shortest.size(); ++i) {
            list.add(Pair.of(first.get(i), second.get(i)));
        }
        return list;
    }

    public static CompoundTag compoundOf(String[] keys, Object ... values) {
        CompoundTag tag = new CompoundTag();
        tag.setValue(Catalyst.mapOf(keys, (Tag[])Catalyst.zip(Catalyst.listOf(keys), Catalyst.listOf(values)).stream().map(pair -> Catalyst.tagOf((String)pair.getLeft(), pair.getRight())).toArray(Tag[]::new)));
        return tag;
    }

    public static <T> Tag<T> tagOf(T value) {
        Tag tag = Tag.createTagOfType(value.getClass());
        tag.setValue(value);
        return tag;
    }

    public static <T> Tag<T> tagOf(String name, T value) {
        Tag tag = Tag.createTagOfType(value.getClass());
        tag.setValue(value);
        tag.setName(name);
        return tag;
    }

    public static long multiMin(long ... values) {
        long min = Long.MAX_VALUE;
        for (long value : values) {
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public static ArrayList<ItemStack> condenseItemList(List<ItemStack> list) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack stack : list) {
            if (stack == null) continue;
            boolean found = false;
            for (ItemStack S : stacks) {
                if (!S.isItemEqual(stack) || !S.getData().equals((Object)stack.getData())) continue;
                S.stackSize += stack.stackSize;
                found = true;
            }
            if (found) continue;
            stacks.add(stack.copy());
        }
        return stacks;
    }

    public static @UnmodifiableView List<ItemStack> collectStacks(Container inv) {
        if (inv == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            stacks.add(i, inv.getItem(i));
        }
        return Collections.unmodifiableList(stacks);
    }

    public static @UnmodifiableView List<ItemStack> collectAndCondenseStacks(Container inv) {
        return Catalyst.condenseItemList(Catalyst.collectStacks(inv));
    }

    public static Pair<Direction, BlockSection> getBlockSurfaceClickPosition(World world, Player player, Side side, Vec2f clickPosition) {
        Direction dir = Direction.getDirectionFromSide(side.getId());
        return Pair.of((Object)((Object)dir), (Object)((Object)BlockSection.getClosestBlockSection(clickPosition)));
    }

    public static Side calculatePlayerFacing(float rotation) {
        return Side.values()[2 + (MathHelper.floor((double)((double)(rotation * 4.0f / 360.0f) + 0.5)) + 2 & 3)];
    }

    public static void displayGui(Player player, Container inventory, int slotIndex, boolean isArmor, String id) {
        ((IMpGui)player).catalyst$displayCustomGUI(inventory, slotIndex, isArmor, id);
    }

    public static void displayGui(Player player, TileEntity tileEntity, String id) {
        ((IMpGui)player).catalyst$displayCustomGUI(tileEntity, id);
    }

    public static void displayGui(Player player, TileEntity tileEntity, String id, CompoundTag data) {
        ((IMpGui)player).catalyst$displayCustomGUI(tileEntity, id, data);
    }

    public static <T> T blockLogic(Block<? extends BlockLogic> block, Class<T> clazz) {
        if (Block.hasLogicClass(block, clazz)) {
            return (T)block.getLogic();
        }
        return null;
    }

    public static <T> T blockLogic(int id, Class<T> clazz) {
        if (Block.hasLogicClass((Block)Blocks.blocksList[id], clazz)) {
            return (T)Blocks.blocksList[id].getLogic();
        }
        return null;
    }

    public static <T> boolean listContains(List<T> list, T o, BiFunction<T, T, Boolean> equals) {
        for (T obj : list) {
            if (!equals.apply(o, obj).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static byte[] HSBtoRGB(float hue, float saturation, float brightness) {
        byte red = 0;
        byte green = 0;
        byte blue = 0;
        if (saturation == 0.0f) {
            green = blue = (byte)(brightness * 255.0f + 0.5f);
            red = blue;
        } else {
            float f3 = (hue - (float)Math.floor(hue)) * 6.0f;
            float f4 = f3 - (float)Math.floor(f3);
            float f5 = brightness * (1.0f - saturation);
            float f6 = brightness * (1.0f - saturation * f4);
            float f7 = brightness * (1.0f - saturation * (1.0f - f4));
            switch ((int)f3) {
                case 0: {
                    red = (byte)(brightness * 255.0f + 0.5f);
                    green = (byte)(f7 * 255.0f + 0.5f);
                    blue = (byte)(f5 * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    red = (byte)(f6 * 255.0f + 0.5f);
                    green = (byte)(brightness * 255.0f + 0.5f);
                    blue = (byte)(f5 * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    red = (byte)(f5 * 255.0f + 0.5f);
                    green = (byte)(brightness * 255.0f + 0.5f);
                    blue = (byte)(f7 * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    red = (byte)(f5 * 255.0f + 0.5f);
                    green = (byte)(f6 * 255.0f + 0.5f);
                    blue = (byte)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    red = (byte)(f7 * 255.0f + 0.5f);
                    green = (byte)(f5 * 255.0f + 0.5f);
                    blue = (byte)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    red = (byte)(brightness * 255.0f + 0.5f);
                    green = (byte)(f5 * 255.0f + 0.5f);
                    blue = (byte)(f6 * 255.0f + 0.5f);
                }
            }
        }
        return new byte[]{red, green, blue};
    }

    public static int random(Random random, int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }
}

