/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.WorldSource;
import sunsetsatellite.catalyst.core.util.vector.Vec3f;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;

public enum Direction {
    X_POS(new Vec3i(1, 0, 0), 5, "EAST", Axis.X, 4.71238898038469),
    X_NEG(new Vec3i(-1, 0, 0), 4, "WEST", Axis.X, 1.5707963267948966),
    Y_POS(new Vec3i(0, 1, 0), 1, "UP", Axis.Y, 0.0),
    Y_NEG(new Vec3i(0, -1, 0), 0, "DOWN", Axis.Y, 0.0),
    Z_POS(new Vec3i(0, 0, 1), 3, "SOUTH", Axis.Z, Math.PI),
    Z_NEG(new Vec3i(0, 0, -1), 2, "NORTH", Axis.Z, 0.0);

    private final Vec3i vec;
    private Direction opposite;
    private final int side;
    private final String name;
    private final Axis axis;
    private final double angle;

    private Direction(Vec3i vec3I, int side, String name, Axis axis, double angle) {
        this.vec = vec3I;
        this.side = side;
        this.name = name;
        this.axis = axis;
        this.angle = angle;
    }

    public TileEntity getTileEntity(WorldSource world, TileEntity tile) {
        Vec3i pos = new Vec3i(tile.x + this.vec.x, tile.y + this.vec.y, tile.z + this.vec.z);
        return world.getTileEntity(pos.x, pos.y, pos.z);
    }

    public Block getBlock(WorldSource world, TileEntity tile) {
        Vec3i pos = new Vec3i(tile.x + this.vec.x, tile.y + this.vec.y, tile.z + this.vec.z);
        return world.getBlock(pos.x, pos.y, pos.z);
    }

    public Block getBlock(WorldSource world, Vec3i baseVec) {
        Vec3i pos = new Vec3i(baseVec.x + this.vec.x, baseVec.y + this.vec.y, baseVec.z + this.vec.z);
        return world.getBlock(pos.x, pos.y, pos.z);
    }

    public TileEntity getTileEntity(WorldSource world, Vec3i baseVec) {
        Vec3i pos = new Vec3i(baseVec.x + this.vec.x, baseVec.y + this.vec.y, baseVec.z + this.vec.z);
        return world.getTileEntity(pos.x, pos.y, pos.z);
    }

    public String getName() {
        return this.name;
    }

    public Direction getOpposite() {
        return this.opposite;
    }

    public Vec3i getVec() {
        return this.vec.copy();
    }

    public static Vec3i[] getVecs() {
        Vec3i[] vecs = new Vec3i[Direction.values().length];
        for (int i = 0; i < Direction.values().length; ++i) {
            vecs[i] = Direction.values()[i].getVec();
        }
        return vecs;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public static Direction getDirectionFromSide(int side) {
        for (Direction dir : Direction.values()) {
            if (dir.side != side) continue;
            return dir;
        }
        return X_NEG;
    }

    public static Direction getFromName(String name) {
        for (Direction dir : Direction.values()) {
            if (!dir.name.equalsIgnoreCase(name)) continue;
            return dir;
        }
        return null;
    }

    public Direction rotate(int amount) {
        if (this == Y_POS || this == Y_NEG) {
            return this;
        }
        return Direction.getDirectionFromSide(net.minecraft.core.util.helper.Direction.getDirectionById((int)this.side).rotate(amount).getId());
    }

    public int getSideNumber() {
        return this.side;
    }

    public Side getSide() {
        return Side.getSideById((int)this.side);
    }

    public Vec3f getVecF() {
        return new Vec3f(this.vec.x, this.vec.y, this.vec.z);
    }

    public double getAngle() {
        return this.angle;
    }

    public Direction shiftAxis() {
        switch (this) {
            case X_POS: {
                return Z_POS;
            }
            case X_NEG: {
                return Z_NEG;
            }
            case Z_POS: {
                return X_POS;
            }
            case Z_NEG: {
                return X_NEG;
            }
        }
        return this;
    }

    public Vec3 getMinecraftVec() {
        return Vec3.getTempVec3((double)this.vec.x, (double)this.vec.y, (double)this.vec.z);
    }

    static {
        Direction.X_POS.opposite = X_NEG;
        Direction.X_NEG.opposite = X_POS;
        Direction.Y_NEG.opposite = Y_POS;
        Direction.Y_POS.opposite = Y_NEG;
        Direction.Z_NEG.opposite = Z_POS;
        Direction.Z_POS.opposite = Z_NEG;
    }
}

