/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.season.SeasonManager;
import sunsetsatellite.catalyst.core.util.BlockInstance;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;

public class HologramWorld
implements WorldSource {
    private final HashMap<Vec3i, BlockInstance> blocks = new HashMap();

    public HologramWorld(ArrayList<BlockInstance> structure) {
        for (BlockInstance block : structure) {
            this.blocks.put(block.pos, block);
        }
    }

    public int getBlockId(int i, int j, int k) {
        Vec3i vec = new Vec3i(i, j, k);
        BlockInstance inst = this.blocks.get(vec);
        if (inst == null) {
            return 0;
        }
        return inst.block.id();
    }

    public Block<?> getBlock(int i, int j, int k) {
        Vec3i vec = new Vec3i(i, j, k);
        BlockInstance inst = this.blocks.get(vec);
        if (inst == null) {
            return null;
        }
        return inst.block;
    }

    public TileEntity getTileEntity(int i, int j, int k) {
        return null;
    }

    public float getBrightness(int i, int j, int k, int l) {
        return 15.0f;
    }

    public int getLightmapCoord(int i, int j, int k, int l) {
        return LightmapHelper.getLightmapCoord((int)15, (int)15);
    }

    public int getLightmapCoord(int i, int j) {
        return LightmapHelper.getLightmapCoord((int)15, (int)15);
    }

    public float getLightBrightness(int i, int j, int k) {
        return 15.0f;
    }

    public int getBlockMetadata(int i, int j, int k) {
        Vec3i vec = new Vec3i(i, j, k);
        BlockInstance inst = this.blocks.get(vec);
        if (inst == null) {
            return 0;
        }
        return inst.meta;
    }

    public Material getBlockMaterial(int i, int j, int k) {
        Vec3i vec = new Vec3i(i, j, k);
        BlockInstance inst = this.blocks.get(vec);
        if (inst == null) {
            return null;
        }
        return inst.block.getMaterial();
    }

    public boolean isBlockOpaqueCube(int i, int j, int k) {
        Vec3i vec = new Vec3i(i, j, k);
        BlockInstance inst = this.blocks.get(vec);
        if (inst == null) {
            return false;
        }
        return inst.block.isSolidRender();
    }

    public boolean isBlockNormalCube(int i, int j, int k) {
        Vec3i vec = new Vec3i(i, j, k);
        BlockInstance inst = this.blocks.get(vec);
        if (inst == null) {
            return false;
        }
        Block<?> block = inst.block;
        return block.getMaterial().isSolidBlocking();
    }

    public double getBlockTemperature(int i, int j) {
        return 0.0;
    }

    public double getBlockHumidity(int i, int j) {
        return 0.0;
    }

    public SeasonManager getSeasonManager() {
        return null;
    }

    public Biome getBlockBiome(int i, int j, int k) {
        return null;
    }

    public int getSavedLightValue(LightLayer lightLayer, int i, int j, int k) {
        return 15;
    }

    public boolean isRetro() {
        return false;
    }
}

