/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util;

public class NumberUtil {
    public static String[] shortSuffixes = new String[]{"k", "M", "B", "T", "qd", "Qn"};
    public static String[] shortMetricSuffixes = new String[]{"k", "M", "G", "T", "P", "E"};
    public static String[] longSuffixes = new String[]{"thousand", "million", "billion", "trillion", "quadrillion", "quintillion"};
    public static String[] longMetricSuffixes = new String[]{"kilo", "Mega", "Giga", "Tera", "Peta", "Exa"};

    public static String format(double value) {
        if (Double.isInfinite(value)) {
            return "inf";
        }
        for (String shortSuffix : shortSuffixes) {
            if (value >= 1000.0) {
                if (!((value /= 1000.0) < 1000.0)) continue;
                return String.format("%.1f%s", value, shortSuffix);
            }
            return String.valueOf((long)value);
        }
        return String.valueOf((long)value);
    }

    public static String formatMetric(double value) {
        if (Double.isInfinite(value)) {
            return "inf";
        }
        for (String shortSuffix : shortMetricSuffixes) {
            if (value >= 1000.0) {
                if (!((value /= 1000.0) < 1000.0)) continue;
                return String.format("%.1f%s", value, shortSuffix);
            }
            return String.valueOf((long)value);
        }
        return String.valueOf((long)value);
    }

    public static String formatTime(double seconds) {
        if (seconds < 60.0) {
            return (long)seconds + "s";
        }
        if (seconds < 3600.0) {
            return (long)seconds / 60L + "min";
        }
        if (seconds < 86400.0) {
            return (long)seconds / 3600L + "h";
        }
        if (seconds < 3.1536E7) {
            return (long)seconds / 86400L + "d";
        }
        return (long)seconds / 31536000L + "yr";
    }
}

