/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util.mp;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityDispatcher;
import org.jetbrains.annotations.NotNull;
import sunsetsatellite.catalyst.core.util.IScreenActionListener;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class PacketScreenAction
implements NetworkMessage {
    public Vec3i pos;
    public Class<? extends TileEntity> tileClass;
    public int id;
    public int button;
    public int channel;

    public PacketScreenAction(int id, int button, int channel, Vec3i pos, Class<? extends TileEntity> tileClass) {
        this.id = id;
        this.button = button;
        this.channel = channel;
        this.pos = pos;
        this.tileClass = tileClass;
    }

    public PacketScreenAction() {
    }

    public void encodeToUniversalPacket(@NotNull UniversalPacket packet) {
        packet.writeInt(this.id);
        packet.writeInt(this.button);
        packet.writeInt(this.channel);
        CompoundTag nbt = new CompoundTag();
        this.pos.writeToNBT(nbt);
        packet.writeCompoundTag(nbt);
        packet.writeString(TileEntityDispatcher.getIDFromClass(this.tileClass).toString());
    }

    public void decodeFromUniversalPacket(@NotNull UniversalPacket packet) {
        this.id = packet.readInt();
        this.button = packet.readInt();
        this.channel = packet.readInt();
        this.pos = new Vec3i(packet.readCompoundTag());
        this.tileClass = TileEntityDispatcher.getClassFromID((String)packet.readString());
    }

    public void handle(NetworkMessage.NetworkContext context) {
        TileEntity tileEntity;
        if (EnvironmentHelper.isServerEnvironment() && context.player.world != null && (tileEntity = context.player.world.getTileEntity(this.pos.x, this.pos.y, this.pos.z)) instanceof IScreenActionListener && tileEntity.worldObj != null) {
            ((IScreenActionListener)tileEntity).buttonClicked(this.id, this.button, this.channel);
        }
    }
}

