/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util.network;

import com.google.common.collect.Maps;
import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.conduit.ConduitCapability;
import sunsetsatellite.catalyst.core.util.conduit.IConduitTile;
import sunsetsatellite.catalyst.core.util.network.NetworkComponent;
import sunsetsatellite.catalyst.core.util.network.NetworkComponentTile;
import sunsetsatellite.catalyst.core.util.network.NetworkManager;
import sunsetsatellite.catalyst.core.util.network.NetworkPath;
import sunsetsatellite.catalyst.core.util.network.NetworkPathMap;
import sunsetsatellite.catalyst.core.util.network.NetworkType;
import sunsetsatellite.catalyst.core.util.network.NetworkWalker;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;

public class Network {
    protected final Map<Vec3i, NetworkComponent> networkBlocks = Maps.newHashMap();
    protected final Map<Vec3i, BlockEntry> blocks = Maps.newHashMap();
    protected final World world;
    protected final int id;
    protected final NetworkPathMap NET_PATH_DATA = new NetworkPathMap();
    protected final Random random;
    public final Color color;
    @NotNull
    public final NetworkType type;

    public Network(World world, @NotNull NetworkType type) {
        this(world, NetworkManager.getUID(), type);
    }

    private Network(World world, int id, @NotNull NetworkType type) {
        this.world = world;
        this.id = id;
        this.type = type;
        this.random = new Random(id);
        this.color = new Color().setRGBA(this.random.nextInt(255), this.random.nextInt(255), this.random.nextInt(255), 255);
    }

    public List<NetworkPath> getPathData(Vec3i pos) {
        List<NetworkPath> routes = (List<NetworkPath>)this.NET_PATH_DATA.get(pos);
        if (routes == null) {
            routes = NetworkWalker.createNetworkPaths(this.world, pos);
            if (routes == null) {
                return Collections.emptyList();
            }
            routes.sort(Comparator.comparingInt(NetworkPath::getDistance));
            this.NET_PATH_DATA.put(pos, routes);
        }
        return routes;
    }

    public int getSize() {
        return this.blocks.size();
    }

    public int getId() {
        return this.id;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean existsOnPos(int x, int y, int z) {
        Vec3i pos = new Vec3i(x, y, z);
        return this.blocks.containsKey(pos);
    }

    public void addBlock(int x, int y, int z) {
        Block b = Blocks.blocksList[this.world.getBlockId(x, y, z)];
        byte meta = (byte)this.world.getBlockMetadata(x, y, z);
        if (b == null || !(b.getLogic() instanceof NetworkComponent)) {
            return;
        }
        Vec3i pos = new Vec3i(x, y, z);
        this.blocks.put(pos, new BlockEntry(b, meta));
        BlockLogic block = b.getLogic();
        if (((NetworkComponent)block).getType().equals(this.type)) {
            this.networkBlocks.put(pos, (NetworkComponent)block);
            if (this.world.getTileEntity(x, y, z) instanceof NetworkComponentTile) {
                ((NetworkComponentTile)this.world.getTileEntity(x, y, z)).networkChanged(this);
            }
        }
        this.update();
        this.NET_PATH_DATA.clear();
    }

    public List<Network> removeBlock(int x, int y, int z) {
        Vec3i pos = new Vec3i(x, y, z);
        NetworkComponent component = this.networkBlocks.get(pos);
        if (component != null && this.world.getTileEntity(x, y, z) instanceof NetworkComponentTile) {
            ((NetworkComponentTile)this.world.getTileEntity(x, y, z)).removedFromNetwork(this);
        }
        this.networkBlocks.remove(pos);
        this.blocks.remove(pos);
        this.update();
        ArrayList<Vec3i> sideNets = new ArrayList<Vec3i>(6);
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            Vec3i offset = Direction.getVecs()[i];
            Vec3i side = new Vec3i(x + offset.x, y + offset.y, z + offset.z);
            if (!this.blocks.containsKey(side)) continue;
            sideNets.add(side);
        }
        ArrayList<Set<Vec3i>> preNets = new ArrayList<Set<Vec3i>>();
        boolean[] ignore = new boolean[sideNets.size()];
        for (int i = 0; i < ignore.length; i = (int)((byte)(i + 1))) {
            if (ignore[i]) continue;
            Vec3i startBlock = (Vec3i)sideNets.get(i);
            Set<Vec3i> netBlocks = this.floodFill(startBlock);
            preNets.add(netBlocks);
            if (i >= ignore.length - 1) continue;
            for (byte by = (byte)(i + 1); by < ignore.length; by = (byte)(by + 1)) {
                if (!netBlocks.contains(sideNets.get(by))) continue;
                ignore[by] = true;
            }
        }
        int size = preNets.size();
        if (size < 2) {
            return null;
        }
        ArrayList<Network> result = new ArrayList<Network>(size);
        for (Set set : preNets) {
            Network sideNet = new Network(this.world, this.type);
            set.forEach(blockPos -> {
                sideNet.blocks.put((Vec3i)blockPos, this.blocks.get(blockPos));
                NetworkComponent netBlock = this.networkBlocks.get(blockPos);
                if (netBlock != null) {
                    sideNet.networkBlocks.put((Vec3i)blockPos, netBlock);
                    TileEntity tile = this.world.getTileEntity(blockPos.x, blockPos.y, blockPos.z);
                    if (tile instanceof NetworkComponentTile) {
                        ((NetworkComponentTile)tile).networkChanged(sideNet);
                    }
                }
            });
            if (sideNet.getSize() <= 1) continue;
            result.add(sideNet);
            sideNet.update();
        }
        this.update();
        this.NET_PATH_DATA.clear();
        return result;
    }

    public void mergeNetwork(Network net) {
        if (net.isOfSameType(net)) {
            this.blocks.putAll(net.blocks);
            this.networkBlocks.putAll(net.networkBlocks);
        }
        this.networkBlocks.forEach((pos, networkComponent) -> {
            TileEntity tile = this.world.getTileEntity(pos.x, pos.y, pos.z);
            if (tile instanceof NetworkComponentTile) {
                ((NetworkComponentTile)tile).networkChanged(net);
            }
        });
        this.NET_PATH_DATA.clear();
    }

    public CompoundTag toTag() {
        CompoundTag net = new CompoundTag();
        ListTag positions = new ListTag();
        net.put("blocks", (Tag)positions);
        net.putInt("id", this.id);
        net.putString("type", this.type.type);
        this.blocks.forEach((pos, entry) -> {
            CompoundTag tag = new CompoundTag();
            tag.putInt("x", pos.x);
            tag.putInt("y", pos.y);
            tag.putInt("z", pos.z);
            tag.putInt("id", entry.block.id());
            tag.putInt("meta", (int)entry.meta);
            positions.addTag((Tag)tag);
        });
        return net;
    }

    public static Network fromTag(World world, CompoundTag root) {
        int id = root.getInteger("id");
        ListTag positions = root.getList("blocks");
        NetworkType networkType = new NetworkType(root.getString("type"));
        Network net = new Network(world, id, networkType);
        int size = positions.tagCount();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag = (CompoundTag)positions.tagAt(i);
            Block block = Blocks.blocksList[tag.getInteger("id")];
            if (block == null) continue;
            int x = tag.getInteger("x");
            int y = tag.getInteger("y");
            int z = tag.getInteger("z");
            byte meta = tag.getByte("meta");
            net.blocks.put(new Vec3i(x, y, z), new BlockEntry(block, meta));
            if (!NetworkManager.canBeNet(block)) continue;
            net.networkBlocks.put(new Vec3i(x, y, z), (NetworkComponent)block.getLogic());
        }
        net.update();
        return net;
    }

    private Set<Vec3i> floodFill(Vec3i start) {
        ArrayList<Set<Vec3i>> edges = new ArrayList<Set<Vec3i>>();
        HashSet<Vec3i> result = new HashSet<Vec3i>();
        edges.add(Catalyst.setOf(start));
        edges.add(new HashSet());
        int n = 0;
        boolean added = true;
        while (added) {
            Set oldEdge = (Set)edges.get(n & 1);
            Set newEdge = (Set)edges.get(n + 1 & 1);
            n = (byte)(n + 1 & 1);
            oldEdge.forEach(pos -> {
                for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                    Vec3i offset = Direction.getVecs()[i];
                    Vec3i side = new Vec3i(pos.x + offset.x, pos.y + offset.y, pos.z + offset.z);
                    if (!this.blocks.containsKey(side) || result.contains(side)) continue;
                    newEdge.add(side);
                }
            });
            added = !oldEdge.isEmpty();
            result.addAll(oldEdge);
            oldEdge.clear();
        }
        return result;
    }

    public void update() {
        this.networkBlocks.forEach((pos, networkComponent) -> {
            TileEntity tile = this.world.getTileEntity(pos.x, pos.y, pos.z);
            if (tile instanceof NetworkComponentTile) {
                ((NetworkComponentTile)tile).networkChanged(this);
            }
        });
        this.NET_PATH_DATA.clear();
    }

    public boolean isOfSameType(NetworkComponent component) {
        return component != null && component.getType().equals(this.type);
    }

    public boolean isOfSameType(Network net) {
        return net.type.equals(this.type);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Network) {
            Network net = (Network)obj;
            Optional optional = net.blocks.keySet().stream().findAny();
            if (optional.isPresent()) {
                Vec3i pos = (Vec3i)optional.get();
                return this.blocks.containsKey(pos);
            }
        }
        return false;
    }

    public String toString() {
        return String.format("[ID: %d, Size: %d]", this.id, this.networkBlocks.size());
    }

    public <T> Set<T> search(Vec3i start, Class<T> clazz) {
        HashSet<T> result = new HashSet<T>();
        List<NetworkPath> paths = this.getPathData(start);
        for (NetworkPath path : paths) {
            if (!clazz.isAssignableFrom(path.target.getClass())) continue;
            if (path.target.getPosition().getTileEntity((WorldSource)this.world) != path.target) {
                this.NET_PATH_DATA.clear();
                continue;
            }
            result.add(clazz.cast(path.target));
        }
        return result;
    }

    public <T> T findFirst(Vec3i start, Class<T> clazz) {
        for (Direction dir : Direction.values()) {
            TileEntity tileEntity = dir.getTileEntity((WorldSource)this.world, start);
            if (!(tileEntity instanceof IConduitTile) || ((IConduitTile)tileEntity).getConduitCapability() != ConduitCapability.RES_NETWORK) continue;
            List<NetworkPath> paths = this.getPathData(((IConduitTile)tileEntity).getPosition());
            for (NetworkPath path : paths) {
                if (!clazz.isAssignableFrom(path.target.getClass()) || path.target.getPosition().getTileEntity((WorldSource)this.world) != path.target) continue;
                return clazz.cast(path.target);
            }
        }
        return null;
    }

    public Set<Vec3i> getPositions() {
        return Collections.unmodifiableSet(this.blocks.keySet());
    }

    protected static class BlockEntry {
        Block<?> block;
        byte meta;

        private BlockEntry(Block<?> block, byte meta) {
            this.block = block;
            this.meta = meta;
        }
    }
}

