/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util.network;

import com.mojang.nbt.NbtIo;
import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.BlockChangeInfo;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.Signal;
import sunsetsatellite.catalyst.core.util.mp.PacketAddNetworkBlock;
import sunsetsatellite.catalyst.core.util.mp.PacketRemoveNetworkBlock;
import sunsetsatellite.catalyst.core.util.network.Network;
import sunsetsatellite.catalyst.core.util.network.NetworkComponent;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class NetworkManager {
    private static final Map<Integer, Set<Network>> NETS = new HashMap<Integer, Set<Network>>();
    private static final AtomicInteger ID_PROVIDER = new AtomicInteger(0);

    private NetworkManager() {
    }

    public static int getNetID(World world, int x, int y, int z) {
        Network net = NetworkManager.getNet(world, x, y, z);
        return net == null ? -1 : net.hashCode();
    }

    public static void addBlock(BlockChangeInfo blockChanged) {
        Network net;
        int px;
        Set nets;
        NetworkComponent component;
        World world;
        int z;
        int y;
        int x;
        block11: {
            Network[] netsArray;
            int size;
            HashSet<Network> sideNets;
            block12: {
                block10: {
                    int pz;
                    int py;
                    x = blockChanged.pos.x;
                    y = blockChanged.pos.y;
                    z = blockChanged.pos.z;
                    world = blockChanged.world;
                    if (!NetworkManager.canBeNet(Blocks.blocksList[blockChanged.id])) {
                        return;
                    }
                    component = Catalyst.blockLogic(blockChanged.id, NetworkComponent.class);
                    nets = NETS.computeIfAbsent(world.dimension.id, i -> new HashSet());
                    sideNets = new HashSet<Network>();
                    for (Network net2 : nets) {
                        for (Vec3i offset : Direction.getVecs()) {
                            px = x + offset.x;
                            py = y + offset.y;
                            pz = z + offset.z;
                            if (!net2.existsOnPos(px, py, pz)) continue;
                            sideNets.add(net2);
                        }
                    }
                    net = null;
                    size = sideNets.size();
                    if (size != 0) break block10;
                    net = new Network(world, component.getType());
                    net.addBlock(x, y, z);
                    for (Vec3i offset : Direction.getVecs()) {
                        px = x + offset.x;
                        py = y + offset.y;
                        pz = z + offset.z;
                        if (!NetworkManager.canBeNet((WorldSource)world, px, py, pz)) continue;
                        net.addBlock(px, py, pz);
                    }
                    if (net.getSize() <= 1) break block11;
                    nets.add(net);
                    break block11;
                }
                if (size != 1) break block12;
                Network potentialNet = (Network)sideNets.stream().findAny().get();
                if (!potentialNet.isOfSameType(component)) break block11;
                potentialNet.addBlock(x, y, z);
                net = potentialNet;
                break block11;
            }
            for (Network network : netsArray = sideNets.toArray(new Network[size])) {
                if (!network.isOfSameType(component)) continue;
                Network main = network;
                main.addBlock(x, y, z);
                for (Network otherNet : netsArray) {
                    if (otherNet == main || !otherNet.isOfSameType(main)) continue;
                    main.mergeNetwork(otherNet);
                    nets.remove(otherNet);
                }
                net = main;
                break;
            }
        }
        if (net == null && NetworkManager.getNet(world, x, y, z) == null) {
            net = new Network(world, component.getType());
            net.addBlock(x, y, z);
            for (Vec3i offset : Direction.getVecs()) {
                px = x + offset.x;
                int py = y + offset.y;
                int pz = z + offset.z;
                if (!NetworkManager.canBeNet((WorldSource)world, px, py, pz)) continue;
                net.addBlock(px, py, pz);
            }
            if (net.getSize() > 1) {
                nets.add(net);
            }
        }
        for (Vec3i offset : Direction.getVecs()) {
            NetworkComponent sideComponent;
            px = x + offset.x;
            int py = y + offset.y;
            int pz = z + offset.z;
            if (!NetworkManager.canBeNet((WorldSource)world, px, py, pz) || NetworkManager.getNet(world, px, py, pz) != null || net == null || !net.isOfSameType(sideComponent = Catalyst.blockLogic((Block<? extends BlockLogic>)world.getBlock(px, py, pz), NetworkComponent.class))) continue;
            net.addBlock(px, py, pz);
        }
    }

    public static void removeBlock(BlockChangeInfo blockChanged) {
        int x = blockChanged.pos.x;
        int y = blockChanged.pos.y;
        int z = blockChanged.pos.z;
        World world = blockChanged.world;
        Set<Network> nets = NETS.get(world.dimension.id);
        if (nets == null) {
            return;
        }
        Network target = null;
        for (Network net : nets) {
            if (!net.existsOnPos(x, y, z)) continue;
            target = net;
            break;
        }
        if (target != null) {
            List<Network> sideNets = target.removeBlock(x, y, z);
            if (sideNets != null) {
                nets.remove(target);
                nets.addAll(sideNets);
            } else if (target.getSize() < 2) {
                nets.remove(target);
            }
        }
    }

    public static int getUID() {
        return ID_PROVIDER.getAndIncrement();
    }

    public static void netsToTag(World world, CompoundTag root) {
        Set<Network> nets = NETS.get(world.dimension.id);
        CompoundTag dimTag = new CompoundTag();
        root.put("dim" + world.dimension.id, (Tag)dimTag);
        if (nets == null) {
            return;
        }
        ListTag netsList = new ListTag();
        dimTag.put("nets", (Tag)netsList);
        nets.forEach(network -> netsList.addTag((Tag)network.toTag()));
    }

    public static void netsFromTag(World world, CompoundTag root) {
        HashSet<Network> nets = new HashSet<Network>();
        NETS.put(world.dimension.id, nets);
        CompoundTag dimTag = root.getCompound("dim" + world.dimension.id);
        if (dimTag == null) {
            return;
        }
        ListTag netsList = dimTag.getList("nets");
        int size = netsList.tagCount();
        for (int i = 0; i < size; ++i) {
            Network net = Network.fromTag(world, (CompoundTag)netsList.tagAt(i));
            net.update();
            if (net.getSize() <= 1) continue;
            nets.add(net);
        }
    }

    public static boolean canBeNet(WorldSource world, int x, int y, int z) {
        Block block = Blocks.blocksList[world.getBlockId(x, y, z)];
        return NetworkManager.canBeNet(block);
    }

    public static boolean canBeNet(Block<?> block) {
        return Block.hasLogicClass(block, NetworkComponent.class);
    }

    public static Network getNet(World world, int x, int y, int z) {
        Set<Network> nets = NETS.get(world.dimension.id);
        if (nets != null) {
            for (Network net : nets) {
                if (!net.existsOnPos(x, y, z)) continue;
                return net;
            }
        }
        return null;
    }

    public static Map<Integer, Set<Network>> getAllNets() {
        return Collections.unmodifiableMap(NETS);
    }

    public static Set<Network> getNetsForDimension(int dim) {
        return Collections.unmodifiableSet(NETS.getOrDefault(dim, Collections.emptySet()));
    }

    public static void clearNets(int dim) {
        NETS.remove(dim);
    }

    public static void updateAllNets() {
        NETS.forEach((dimId, nets) -> {
            for (Network net : nets) {
                net.update();
            }
        });
    }

    public static class LoadSaveListener
    implements Signal.Listener<World> {
        public static final Signal.Listener<World> INSTANCE = new LoadSaveListener();

        @Override
        public void signalEmitted(Signal<World> signal, World world) {
            if (signal == Catalyst.DIMENSION_LOAD_SIGNAL) {
                File file = world.getSaveHandler().getDataFile("networks_" + world.dimension.id);
                if (file == null) {
                    return;
                }
                if (file.exists()) {
                    try {
                        CompoundTag tag = NbtIo.readCompressed((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0]));
                        NetworkManager.netsFromTag(world, tag);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else if (signal == Catalyst.DIMENSION_SAVE_SIGNAL) {
                try {
                    File file = world.getSaveHandler().getDataFile("networks_" + world.dimension.id);
                    if (file == null) {
                        return;
                    }
                    CompoundTag tag = new CompoundTag();
                    try {
                        tag = NbtIo.readCompressed((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0]));
                    }
                    catch (NoSuchFileException e) {
                        Catalyst.LOGGER.info("Creating new networks file for dimension {}!", (Object)world.dimension.id);
                    }
                    NetworkManager.netsToTag(world, tag);
                    NbtIo.writeCompressed((CompoundTag)tag, (OutputStream)Files.newOutputStream(file.toPath(), new OpenOption[0]));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class BlockChangeListener
    implements Signal.Listener<BlockChangeInfo> {
        public static final Signal.Listener<BlockChangeInfo> INSTANCE = new BlockChangeListener();

        @Override
        public void signalEmitted(Signal<BlockChangeInfo> signal, BlockChangeInfo blockChanged) {
            if (signal != Catalyst.TILE_ENTITY_BLOCK_CHANGED_SIGNAL) {
                return;
            }
            if (blockChanged.id == 0) {
                NetworkHandler.sendToAllPlayers((NetworkMessage)new PacketRemoveNetworkBlock(blockChanged.pos.x, blockChanged.pos.y, blockChanged.pos.z, blockChanged.world.dimension.id));
                NetworkManager.removeBlock(blockChanged);
            } else {
                NetworkHandler.sendToAllPlayers((NetworkMessage)new PacketAddNetworkBlock(blockChanged.pos.x, blockChanged.pos.y, blockChanged.pos.z, blockChanged.id, blockChanged.meta, blockChanged.world.dimension.id));
                NetworkManager.addBlock(blockChanged);
            }
        }
    }
}

