/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util.network;

import com.llamalad7.mixinextras.lib.apache.commons.ArrayUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.conduit.IConduitTile;
import sunsetsatellite.catalyst.core.util.network.NetworkComponent;
import sunsetsatellite.catalyst.core.util.network.NetworkComponentTile;
import sunsetsatellite.catalyst.core.util.network.NetworkPath;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;

public class NetworkWalker<T extends NetworkComponentTile> {
    protected NetworkWalker<T> root;
    private final World world;
    private Set<T> walkedConduits;
    private final List<Direction> nextConduitDirections = new ArrayList<Direction>(Direction.values().length - 1);
    private final List<T> nextConduits = new ArrayList<T>(Direction.values().length - 1);
    private List<NetworkWalker<T>> walkers;
    private Vec3i currentPos;
    private T currentConduit;
    private Direction from = null;
    private int walkedBlocks;
    private boolean used;
    private boolean running;
    private boolean failed = false;
    private T[] conduits;
    private final List<NetworkPath> routes;

    public NetworkWalker(World world, Vec3i source, int walkedBlocks, List<NetworkPath> routes) {
        this.world = world;
        this.walkedBlocks = walkedBlocks;
        this.currentPos = source;
        this.root = this;
        this.routes = routes;
    }

    public static <T extends NetworkComponentTile> List<NetworkPath> createNetworkPaths(World world, Vec3i source) {
        if (source.getTileEntity((WorldSource)world) instanceof NetworkComponentTile) {
            NetworkWalker<T> walker = new NetworkWalker<T>(world, source, 1, new ArrayList<NetworkPath>());
            walker.traverse();
            return walker.isFailed() ? null : walker.routes;
        }
        return null;
    }

    protected NetworkWalker<T> createSubWalker(World world, Direction nextDir, Vec3i nextPos, int walkedBlocks) {
        NetworkWalker<T> subWalker = new NetworkWalker<T>(world, nextPos, walkedBlocks, this.routes);
        subWalker.conduits = this.conduits;
        return subWalker;
    }

    public void traverse() {
        this.traverse(32768);
    }

    public void traverse(int max) {
        if (this.used) {
            throw new IllegalStateException("Walker already used!");
        }
        this.root = this;
        this.walkedConduits = new HashSet<T>();
        int i = 0;
        this.running = true;
        while (this.running && !this.walk() && i++ < max) {
        }
        this.running = false;
        this.walkedConduits = null;
        if (i >= max) {
            Catalyst.LOGGER.error("Walker reached maximum amount of walks: {}", (Object)i);
        }
        this.used = true;
    }

    private boolean walk() {
        if (this.walkers == null) {
            if (!this.checkPos()) {
                this.root.failed = true;
                return true;
            }
            if (this.nextConduitDirections.isEmpty()) {
                return true;
            }
            if (this.nextConduitDirections.size() == 1) {
                this.currentPos = ((NetworkComponentTile)this.nextConduits.get(0)).getPosition();
                this.currentConduit = (NetworkComponentTile)this.nextConduits.get(0);
                this.from = this.nextConduitDirections.get(0).getOpposite();
                ++this.walkedBlocks;
                return !this.isRunning();
            }
            this.walkers = new ArrayList<NetworkWalker<T>>();
            for (int i = 0; i < this.nextConduitDirections.size(); ++i) {
                Direction direction = this.nextConduitDirections.get(i);
                NetworkWalker<T> walker = this.createSubWalker(this.world, direction, this.currentPos.copy().add(direction.getVec()), this.walkedBlocks + 1);
                walker.root = this.root;
                walker.currentConduit = (NetworkComponentTile)this.nextConduits.get(i);
                walker.from = direction.getOpposite();
                this.walkers.add(walker);
            }
        }
        Iterator<NetworkWalker<T>> iterator = this.walkers.iterator();
        while (iterator.hasNext()) {
            NetworkWalker<T> next = iterator.next();
            if (!super.walk()) continue;
            this.onRemoveSubWalker(next);
            iterator.remove();
        }
        return !this.isRunning() || this.walkers.isEmpty();
    }

    private boolean checkPos() {
        this.nextConduitDirections.clear();
        this.nextConduits.clear();
        if (this.currentConduit == null) {
            TileEntity thisConduit = this.world.getTileEntity(this.currentPos.x, this.currentPos.y, this.currentPos.z);
            Block block = this.world.getBlock(this.currentPos.x, this.currentPos.y, this.currentPos.z);
            if (!(thisConduit instanceof IConduitTile) || block == null) {
                return false;
            }
            this.currentConduit = (NetworkComponentTile)thisConduit;
        }
        this.checkConduit(this.currentConduit, this.currentPos);
        this.root.walkedConduits.add(this.currentConduit);
        for (Direction direction : this.getAllowedDirections()) {
            if (direction == this.from || !this.currentConduit.isConnected(direction)) continue;
            TileEntity tile = direction.getTileEntity((WorldSource)this.world, (TileEntity)this.currentConduit);
            Block block = direction.getBlock((WorldSource)this.world, (TileEntity)this.currentConduit);
            if (tile instanceof IConduitTile && block != null) {
                NetworkComponentTile otherConduit = (NetworkComponentTile)tile;
                if (!otherConduit.isConnected(direction.getOpposite()) || this.isWalked(otherConduit)) continue;
                if (this.isValid(this.currentConduit, otherConduit, this.currentPos, direction)) {
                    this.nextConduitDirections.add(direction);
                    this.nextConduits.add(otherConduit);
                    continue;
                }
            }
            this.checkNeighbour(this.currentConduit, this.currentPos, direction, tile);
        }
        return true;
    }

    protected void checkNeighbour(T conduit, Vec3i pos, Direction dirToNeighbour, TileEntity neighbour) {
        if (conduit != this.conduits[this.conduits.length - 1]) {
            throw new IllegalStateException("Current conduit is not the last one added, you dun goofed.");
        }
        if (!(neighbour instanceof IConduitTile) && neighbour.getBlock() != null && neighbour.getBlock().getLogic() instanceof NetworkComponent) {
            NetworkComponentTile[] path = new NetworkComponentTile[this.conduits.length + 1];
            System.arraycopy(this.conduits, 0, path, 0, this.conduits.length);
            path[path.length - 1] = (NetworkComponentTile)neighbour;
            this.routes.add(new NetworkPath(dirToNeighbour, path, this.getWalkedBlocks()));
        }
    }

    protected boolean isValid(T conduit, T neighbourConduit, Vec3i pos, Direction dirToNeighbour) {
        if (pos.getBlock((WorldSource)this.world) == null) {
            return false;
        }
        return conduit.getType() == neighbourConduit.getType();
    }

    protected Direction[] getAllowedDirections() {
        return Direction.values();
    }

    private void checkConduit(T currentConduit, Vec3i currentPos) {
        this.conduits = (NetworkComponentTile[])ArrayUtils.add((Object[])this.conduits, currentConduit);
    }

    protected void onRemoveSubWalker(NetworkWalker<T> subWalker) {
    }

    protected boolean isWalked(T conduit) {
        return this.root.walkedConduits.contains(conduit);
    }

    public void stop() {
        this.root.running = false;
    }

    public int getWalkedBlocks() {
        return this.walkedBlocks;
    }

    public boolean isRoot() {
        return this.root == this;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public boolean isRunning() {
        return this.root.running;
    }
}

