/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util.vector;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.util.helper.MathHelper;

public class Vec2i {
    public int x;
    public int y;

    public Vec2i(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Vec2i() {
        this.y = 0;
        this.x = 0;
    }

    public Vec2i(int size) {
        this.x = this.y = size;
    }

    public Vec2i(CompoundTag tag) {
        this.readFromNBT(tag);
    }

    public double distanceTo(Vec2i vec3f) {
        int d = vec3f.x - this.x;
        int d1 = vec3f.y - this.y;
        return MathHelper.sqrt((double)(d * d + d1 * d1));
    }

    public Vec2i add(int value) {
        this.x += value;
        this.y += value;
        return this;
    }

    public Vec2i subtract(int value) {
        this.x -= value;
        this.y -= value;
        return this;
    }

    public Vec2i divide(int value) {
        this.x /= value;
        this.y /= value;
        return this;
    }

    public Vec2i multiply(int value) {
        this.x *= value;
        this.y *= value;
        return this;
    }

    public Vec2i add(Vec2i value) {
        this.x += value.x;
        this.y += value.y;
        return this;
    }

    public Vec2i subtract(Vec2i value) {
        this.x -= value.x;
        this.y -= value.y;
        return this;
    }

    public Vec2i divide(Vec2i value) {
        this.x /= value.x;
        this.y /= value.y;
        return this;
    }

    public Vec2i multiply(Vec2i value) {
        this.x *= value.x;
        this.y *= value.y;
        return this;
    }

    public void writeToNBT(CompoundTag tag) {
        tag.putInt("x", this.x);
        tag.putInt("y", this.y);
    }

    public void readFromNBT(CompoundTag tag) {
        this.x = tag.getInteger("x");
        this.y = tag.getInteger("y");
    }

    public Vec2i copy() {
        return new Vec2i(this.x, this.y);
    }

    public String toString() {
        return "Vec2i{x=" + this.x + ", y=" + this.y + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vec2i vec2i = (Vec2i)o;
        if (this.x != vec2i.x) {
            return false;
        }
        return this.y == vec2i.y;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        return result;
    }
}

