/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util.vector;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.MathHelper;
import sunsetsatellite.catalyst.core.util.vector.Vec2f;

public class Vec3f {
    public double x;
    public double y;
    public double z;

    public Vec3f(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3f() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public Vec3f(double size) {
        this.y = this.z = size;
        this.x = this.z;
    }

    public Vec3f(CompoundTag tag) {
        this.readFromNBT(tag);
    }

    public double distanceTo(Vec3f vec3f) {
        double d = vec3f.x - this.x;
        double d1 = vec3f.y - this.y;
        double d2 = vec3f.z - this.z;
        return MathHelper.sqrt((double)(d * d + d1 * d1 + d2 * d2));
    }

    public Vec3f add(double value) {
        this.x += value;
        this.y += value;
        this.z += value;
        return this;
    }

    public Vec3f subtract(double value) {
        this.x -= value;
        this.y -= value;
        this.z -= value;
        return this;
    }

    public Vec3f divide(double value) {
        this.x /= value;
        this.y /= value;
        this.z /= value;
        return this;
    }

    public Vec3f multiply(double value) {
        this.x *= value;
        this.y *= value;
        this.z *= value;
        return this;
    }

    public Vec3f add(Vec3f value) {
        this.x += value.x;
        this.y += value.y;
        this.z += value.z;
        return this;
    }

    public Vec3f subtract(Vec3f value) {
        this.x -= value.x;
        this.y -= value.y;
        this.z -= value.z;
        return this;
    }

    public Vec3f divide(Vec3f value) {
        this.x /= value.x;
        this.y /= value.y;
        this.z /= value.z;
        return this;
    }

    public Vec3f multiply(Vec3f value) {
        this.x *= value.x;
        this.y *= value.y;
        this.z *= value.z;
        return this;
    }

    public void writeToNBT(CompoundTag tag) {
        tag.putDouble("x", this.x);
        tag.putDouble("y", this.y);
        tag.putDouble("z", this.z);
    }

    public void readFromNBT(CompoundTag tag) {
        this.x = tag.getDouble("x");
        this.y = tag.getDouble("y");
        this.z = tag.getDouble("z");
    }

    public Vec3f copy() {
        return new Vec3f(this.x, this.y, this.z);
    }

    public Vec3f floor() {
        this.x = Math.floor(this.x);
        this.y = Math.floor(this.y);
        this.z = Math.floor(this.z);
        return this;
    }

    public Vec3f ceil() {
        this.x = Math.ceil(this.x);
        this.y = Math.ceil(this.y);
        this.z = Math.ceil(this.z);
        return this;
    }

    public Vec3f round() {
        this.x = Math.round(this.x);
        this.y = Math.round(this.y);
        this.z = Math.round(this.z);
        return this;
    }

    public Vec3f abs() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
        return this;
    }

    public Vec3f lerp(Vec3f to, double amount) {
        double lerpX = this.x + (to.x - this.x) * amount;
        double lerpY = this.y + (to.y - this.x) * amount;
        double lerpZ = this.z + (to.z - this.x) * amount;
        return new Vec3f(lerpX, lerpY, lerpZ);
    }

    public String toString() {
        return String.format("(%f, %f, %f)", this.x, this.y, this.z);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vec3f vec3I = (Vec3f)o;
        if (this.x != vec3I.x) {
            return false;
        }
        if (this.y != vec3I.y) {
            return false;
        }
        return this.z == vec3I.z;
    }

    public Vec3f set(Axis axis, double value) {
        switch (axis) {
            case X: {
                this.x = value;
                return this;
            }
            case Y: {
                this.y = value;
                return this;
            }
            case Z: {
                this.z = value;
                return this;
            }
        }
        return this;
    }

    public double get(Axis axis) {
        switch (axis) {
            case X: {
                return this.x;
            }
            case Y: {
                return this.y;
            }
            case Z: {
                return this.z;
            }
        }
        return 0.0;
    }

    public Vec2f toVec2f() {
        double[] nonZeroValues = new double[3];
        int nonZeroCount = 0;
        if (this.x != 0.0) {
            nonZeroValues[nonZeroCount++] = this.x;
        }
        if (this.y != 0.0) {
            nonZeroValues[nonZeroCount++] = this.y;
        }
        if (this.z != 0.0) {
            nonZeroValues[nonZeroCount++] = this.z;
        }
        if (nonZeroCount != 2) {
            return null;
        }
        return new Vec2f(nonZeroValues[0], nonZeroValues[1]);
    }

    public int hashCode() {
        int result = (int)this.x;
        result = (int)((double)(31 * result) + this.y);
        result = (int)((double)(31 * result) + this.z);
        return result;
    }
}

