/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util.vector;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.WorldSource;
import sunsetsatellite.catalyst.core.util.Direction;
import sunsetsatellite.catalyst.core.util.vector.Vec3f;

public class Vec3i {
    public int x;
    public int y;
    public int z;

    public Vec3i(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3i() {
        this.z = 0;
        this.y = 0;
        this.x = 0;
    }

    public Vec3i(int size) {
        this.y = this.z = size;
        this.x = this.z;
    }

    public Vec3i(CompoundTag tag) {
        this.readFromNBT(tag);
    }

    public String toString() {
        return String.format("(%d, %d, %d)", this.x, this.y, this.z);
    }

    public double distanceTo(Vec3f vec3f) {
        double d = vec3f.x - (double)this.x;
        double d1 = vec3f.y - (double)this.y;
        double d2 = vec3f.z - (double)this.z;
        return MathHelper.sqrt((double)(d * d + d1 * d1 + d2 * d2));
    }

    public double distanceTo(Vec3i vec3i) {
        double d = vec3i.x - this.x;
        double d1 = vec3i.y - this.y;
        double d2 = vec3i.z - this.z;
        return MathHelper.sqrt((double)(d * d + d1 * d1 + d2 * d2));
    }

    public void set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3i add(int value) {
        this.x += value;
        this.y += value;
        this.z += value;
        return this;
    }

    public Vec3i subtract(int value) {
        this.x -= value;
        this.y -= value;
        this.z -= value;
        return this;
    }

    public Vec3i divide(int value) {
        this.x /= value;
        this.y /= value;
        this.z /= value;
        return this;
    }

    public Vec3i multiply(int value) {
        this.x *= value;
        this.y *= value;
        this.z *= value;
        return this;
    }

    public Vec3i add(Vec3i value) {
        this.x += value.x;
        this.y += value.y;
        this.z += value.z;
        return this;
    }

    public Vec3i subtract(Vec3i value) {
        this.x -= value.x;
        this.y -= value.y;
        this.z -= value.z;
        return this;
    }

    public Vec3i divide(Vec3i value) {
        this.x /= value.x;
        this.y /= value.y;
        this.z /= value.z;
        return this;
    }

    public Vec3i multiply(Vec3i value) {
        this.x *= value.x;
        this.y *= value.y;
        this.z *= value.z;
        return this;
    }

    public Vec3i rotate(Vec3i origin, Direction direction) {
        Vec3i pos = this;
        switch (direction) {
            case Z_POS: {
                pos = new Vec3i(this.z + origin.x, this.y + origin.y, this.x + origin.z);
                break;
            }
            case Z_NEG: {
                pos = new Vec3i(-this.z + origin.x, this.y + origin.y, -this.x + origin.z);
                break;
            }
            case X_NEG: {
                pos = new Vec3i(-this.x + origin.x, this.y + origin.y, -this.z + origin.z);
                break;
            }
            case X_POS: {
                pos = new Vec3i(this.x + origin.x, this.y + origin.y, this.z + origin.z);
            }
        }
        return pos;
    }

    public Vec3i rotate(Direction direction) {
        Vec3i pos = this;
        switch (direction) {
            case Z_POS: {
                pos = new Vec3i(this.z, this.y, this.x);
                break;
            }
            case Z_NEG: {
                pos = new Vec3i(-this.z, this.y, -this.x);
                break;
            }
            case X_NEG: {
                pos = new Vec3i(-this.x, this.y, -this.z);
                break;
            }
            case X_POS: {
                pos = new Vec3i(this.x, this.y, this.z);
            }
        }
        return pos;
    }

    public Vec3i rotateX(double angle) {
        float cosine = MathHelper.cos((float)((float)angle));
        float sine = MathHelper.sin((float)((float)angle));
        this.y = (int)Math.round((double)this.y * (double)cosine + (double)this.z * (double)sine);
        this.z = (int)Math.round((double)this.z * (double)cosine - (double)this.y * (double)sine);
        return this;
    }

    public Vec3i rotateY(double angle) {
        float cosine = MathHelper.cos((float)((float)angle));
        float sine = MathHelper.sin((float)((float)angle));
        this.x = (int)Math.round((double)this.x * (double)cosine + (double)this.z * (double)sine);
        this.z = (int)Math.round((double)this.z * (double)cosine - (double)this.x * (double)sine);
        return this;
    }

    public Vec3i rotateX(Vec3i origin, double angle) {
        this.add(origin);
        float cosine = MathHelper.cos((float)((float)angle));
        float sine = MathHelper.sin((float)((float)angle));
        this.y = (int)Math.round((double)this.y * (double)cosine + (double)this.z * (double)sine);
        this.z = (int)Math.round((double)this.z * (double)cosine - (double)this.y * (double)sine);
        return this;
    }

    public Vec3i rotateY(Vec3i origin, double angle) {
        float cosine = MathHelper.cos((float)((float)angle));
        float sine = MathHelper.sin((float)((float)angle));
        this.x = (int)Math.round((double)this.x * (double)cosine + (double)this.z * (double)sine);
        this.z = (int)Math.round((double)this.z * (double)cosine - (double)this.x * (double)sine);
        this.add(origin);
        return this;
    }

    public Vec3i set(Axis axis, int value) {
        switch (axis) {
            case X: {
                this.x = value;
                return this;
            }
            case Y: {
                this.y = value;
                return this;
            }
            case Z: {
                this.z = value;
                return this;
            }
        }
        return this;
    }

    public int get(Axis axis) {
        switch (axis) {
            case X: {
                return this.x;
            }
            case Y: {
                return this.y;
            }
            case Z: {
                return this.z;
            }
        }
        return 0;
    }

    public void writeToNBT(CompoundTag tag) {
        tag.putInt("x", this.x);
        tag.putInt("y", this.y);
        tag.putInt("z", this.z);
    }

    public void readFromNBT(CompoundTag tag) {
        this.x = tag.getInteger("x");
        this.y = tag.getInteger("y");
        this.z = tag.getInteger("z");
    }

    public Vec3i copy() {
        return new Vec3i(this.x, this.y, this.z);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vec3i vec3I = (Vec3i)o;
        if (this.x != vec3I.x) {
            return false;
        }
        if (this.y != vec3I.y) {
            return false;
        }
        return this.z == vec3I.z;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public TileEntity getTileEntity(WorldSource worldSource) {
        return worldSource.getTileEntity(this.x, this.y, this.z);
    }

    public Block<?> getBlock(WorldSource worldSource) {
        return worldSource.getBlock(this.x, this.y, this.z);
    }

    public int getBlockMetadata(WorldSource worldSource) {
        return worldSource.getBlockMetadata(this.x, this.y, this.z);
    }

    public double getSqDistanceTo(int x, int y, int z) {
        int dx = this.x - x;
        int dy = this.y - y;
        int dz = this.z - z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }
}

