/*
 * Decompiled with CFR 0.152.
 */
package com.github.olypolyu.digraphs;

import com.github.olypolyu.digraphs.DigraphMod;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import turniplabs.halplibe.util.TomlConfigHandler;
import turniplabs.halplibe.util.toml.Toml;

public class DigraphConfig {
    private static TomlConfigHandler cfg;
    public static final Set<Character> digraphs;

    static void setup() {
        DigraphMod.LOGGER.info("Initializing config..");
        Toml props = new Toml("digraph_config.toml");
        digraphs.add(Character.valueOf('~'));
        digraphs.add(Character.valueOf('#'));
        props.addEntry("digraphs", "You can use this to modify the digraphs. \nThey should separated by commas, example: \"e, r, #, ~\"", (Object)DigraphConfig.serialize(digraphs));
        cfg = new TomlConfigHandler("digraphs", props);
        if (cfg.getConfigFile().exists()) {
            cfg.loadConfig();
            digraphs.clear();
            digraphs.addAll(DigraphConfig.deserialize(cfg.getString("digraphs")));
        } else {
            try {
                cfg.getConfigFile().createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            cfg.writeConfig();
        }
    }

    private static String serialize(Set<Character> chars) {
        if (chars.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Iterator<Character> it = chars.iterator();
        result.append(it.next());
        while (it.hasNext()) {
            result.append(", ");
            result.append(it.next());
        }
        return result.toString();
    }

    private static Set<Character> deserialize(String chars) {
        String[] split;
        HashSet<Character> result = new HashSet<Character>();
        for (String c : split = chars.split(",")) {
            String trimmed = c.trim();
            if (trimmed.length() > 1) {
                throw new RuntimeException("Invalid syntax for configuration! Please only one character per entry!");
            }
            result.add(Character.valueOf(trimmed.toCharArray()[0]));
        }
        return result;
    }

    static {
        digraphs = new HashSet<Character>();
    }
}

