/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.blocks.terrain;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicAxisAligned;
import net.minecraft.core.block.BlockLogicLog;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import teamport.aether.items.AetherItems;
import teamport.aether.mixin.accessors.ItemAccessor;

public class BlockLogicLogAether
extends BlockLogicLog {
    public BlockLogicLogAether(Block<?> block) {
        super(block);
    }

    public void onBlockPlacedByMob(World world, int x, int y, int z, @NotNull Side side, Mob mob, double xPlaced, double yPlaced) {
        Axis axis = mob.getPlacementDirection(side, PlacementMode.SIDE).getAxis();
        world.setBlockMetadataWithNotify(x, y, z, BlockLogicAxisAligned.axisToMeta((Axis)axis) + 4);
    }

    public void onBlockDestroyedByPlayer(World world, int x, int y, int z, Side side, int meta, Player player, Item item) {
        ItemStack heldItem = player.getHeldItem();
        if (heldItem != null && heldItem.getItem().equals(AetherItems.TOOL_AXE_SKYROOT) && meta == 0 && player.getGamemode().consumeBlocks()) {
            this.harvestBlock(world, player, x, y, z, 1, world.getTileEntity(x, y, z));
        }
    }

    public ItemStack[] getAdditionalBreakResult(World world, Item tool, ItemStack[] results, int meta) {
        if (results == null) {
            return null;
        }
        if (tool != null && tool.equals(AetherItems.TOOL_AXE_SKYROOT) && meta == 0) {
            ItemStack[] doubleStack = new ItemStack[results.length << 1];
            System.arraycopy(results, 0, doubleStack, 0, results.length);
            System.arraycopy(results, 0, doubleStack, results.length, results.length);
            return doubleStack;
        }
        if (tool != null && tool.equals(AetherItems.TOOL_AXE_HOLYSTONE)) {
            assert (results.length <= 64);
            Random random = ((ItemAccessor)tool).getItemRand();
            int count = 0;
            for (int i = 0; i < results.length; ++i) {
                if (random.nextInt(16) != 0) continue;
                ++count;
            }
            ItemStack[] addedAmbrosium = new ItemStack[results.length + 1];
            System.arraycopy(results, 0, addedAmbrosium, 0, results.length);
            addedAmbrosium[results.length] = new ItemStack(AetherItems.AMBROSIUM, count);
            return addedAmbrosium;
        }
        return results;
    }
}

