/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilderLiteral;
import com.mojang.brigadier.builder.ArgumentBuilderRequired;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.ArgumentTypeVec3;
import net.minecraft.core.net.command.helpers.DoubleCoordinates;
import net.minecraft.core.world.World;
import teamport.aether.AetherMod;

public class CommandCount
implements CommandManager.CommandRegistry {
    public void register(CommandDispatcher<CommandSource> commandDispatcher) {
        commandDispatcher.register((ArgumentBuilderLiteral)((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"aether:countBlocks").requires(t -> ((CommandSource)t).hasAdmin())).then(ArgumentBuilderRequired.argument((String)"first", (ArgumentType)ArgumentTypeVec3.vec3d()).then(ArgumentBuilderRequired.argument((String)"second", (ArgumentType)ArgumentTypeVec3.vec3d()).executes(c -> {
            CommandSource sauce = (CommandSource)c.getSource();
            World world = sauce.getWorld();
            DoubleCoordinates first = (DoubleCoordinates)c.getArgument("first", DoubleCoordinates.class);
            DoubleCoordinates second = (DoubleCoordinates)c.getArgument("second", DoubleCoordinates.class);
            int fx = (int)Math.round(first.getX(sauce));
            int fy = (int)Math.round(first.getY(sauce, true));
            int fz = (int)Math.round(first.getZ(sauce));
            int sx = (int)Math.round(second.getX(sauce));
            int sy = (int)Math.round(second.getY(sauce, true));
            int sz = (int)Math.round(second.getZ(sauce));
            HashMap<String, Integer> count = new HashMap<String, Integer>();
            for (int x = Math.min(fx, sx); x <= Math.max(fx, sx); ++x) {
                for (int y = Math.min(fy, sy); y <= Math.max(fy, sy); ++y) {
                    for (int z = Math.min(fz, sz); z <= Math.max(fz, sz); ++z) {
                        int id = world.getBlockId(x, y, z);
                        Block block = Blocks.getBlock((int)id);
                        String name = block == null ? "Air" : AetherMod.TRANSLATOR.translateNameKey(block.getLanguageKey(0));
                        count.merge(name, 1, Integer::sum);
                    }
                }
            }
            long total = (long)Math.abs(fx - sx) * (long)Math.abs(fy - sy) * (long)Math.abs(fz - sz);
            sauce.sendMessage("Total Blocks:" + total);
            count.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).forEach(entry -> sauce.sendMessage((String)entry.getKey() + "\u2192 Count: " + entry.getValue()));
            return 1;
        }))));
    }
}

