/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.effect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.data.tag.ITaggable;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.collection.NamespaceID;
import sunsetsatellite.catalyst.effects.api.attribute.Attribute;
import sunsetsatellite.catalyst.effects.api.attribute.Attributes;
import sunsetsatellite.catalyst.effects.api.attribute.type.IntAttribute;
import sunsetsatellite.catalyst.effects.api.effect.Effect;
import sunsetsatellite.catalyst.effects.api.effect.EffectContainer;
import sunsetsatellite.catalyst.effects.api.effect.EffectStack;
import sunsetsatellite.catalyst.effects.api.effect.EffectTagDispatcher;
import sunsetsatellite.catalyst.effects.api.effect.EffectTimeType;
import sunsetsatellite.catalyst.effects.api.effect.Effects;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;
import sunsetsatellite.catalyst.effects.api.effect.render.EffectRendererDispatcher;
import sunsetsatellite.catalyst.effects.api.modifier.ModifierType;
import sunsetsatellite.catalyst.effects.api.modifier.type.IntModifier;
import teamport.aether.effect.ILockInteractable;
import teamport.aether.effect.PoisonEffect;
import teamport.aether.effect.RemedyEffect;
import teamport.aether.effect.render.AetherCustomHeartContainer;
import teamport.aether.effect.render.ExtraHealthEffectRenderer;
import teamport.aether.effect.render.PoisonEffectRenderer;
import teamport.aether.effect.render.RemedyEffectRenderer;
import teamport.aether.entity.boss.slider.MobBossSlider;
import teamport.aether.entity.boss.sunspirit.MobBossSunspirit;
import teamport.aether.entity.boss.valkyrie.queen.MobBossValkyrie;
import teamport.aether.entity.monster.aechorplant.MobAechorPlant;
import teamport.aether.entity.monster.cockatrice.MobCockatrice;
import teamport.aether.entity.monster.fireminion.MobFireMinion;
import teamport.aether.entity.monster.sentry.MobSentry;
import teamport.aether.entity.monster.valkyrie.MobValkyrie;
import teamport.aether.items.AetherItems;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class AetherEffects {
    private static boolean hasInit = false;
    public static IntAttribute EXTRA_HEALTH = (IntAttribute)new IntAttribute("attribute.aether.extraHealth", Integer.valueOf(0)).setAsDefault();
    public static Effect poisonEffect;
    public static Effect remedyEffect;
    public static Effect extraHealthEffect;
    public static Tag<Effect> IMMUNE_TO_POISON;

    public static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        AetherEffects.registerAttributes();
        AetherEffects.assignEffects();
        AetherEffects.registerEffects();
        if (!EnvironmentHelper.isServerEnvironment()) {
            AetherEffects.assignEffectRenderers();
        }
    }

    private static void registerAttributes() {
        Attributes catalystAttributes = Attributes.getInstance();
        catalystAttributes.register("aether:extra_health", (Object)EXTRA_HEALTH);
    }

    private static void assignEffects() {
        extraHealthEffect = new Effect("effect.aether.extra_health", "aether:extra_health", Collections.singletonList(new IntModifier((Attribute)EXTRA_HEALTH, ModifierType.ADD, 1)), EffectTimeType.PERMANENT, 40).setPersistent();
        poisonEffect = new PoisonEffect("effect.aether.poison", "aether:poison", new ArrayList(), EffectTimeType.KEEP, 10).setDefaultDuration(60);
        remedyEffect = new RemedyEffect("effect.aether.remedy", "aether:remedy", new ArrayList(), EffectTimeType.RESET, 1).setDefaultDuration(240);
        AetherEffects.registerLock(poisonEffect, remedyEffect);
    }

    private static void registerEffects() {
        Effects effects = Effects.getInstance();
        effects.register(AetherEffects.extraHealthEffect.id, (Object)extraHealthEffect);
        effects.register(AetherEffects.poisonEffect.id, (Object)poisonEffect);
        effects.register(AetherEffects.remedyEffect.id, (Object)remedyEffect);
        IMMUNE_TO_POISON.tag((ITaggable)poisonEffect);
        EffectTagDispatcher.setImmunityFor(MobAechorPlant.class, (Tag[])new Tag[]{IMMUNE_TO_POISON});
        EffectTagDispatcher.setImmunityFor(MobCockatrice.class, (Tag[])new Tag[]{IMMUNE_TO_POISON});
        EffectTagDispatcher.setImmunityFor(MobSentry.class, (Tag[])new Tag[]{IMMUNE_TO_POISON});
        EffectTagDispatcher.setImmunityFor(MobBossSlider.class, (Tag[])new Tag[]{IMMUNE_TO_POISON});
        EffectTagDispatcher.setImmunityFor(MobValkyrie.class, (Tag[])new Tag[]{IMMUNE_TO_POISON});
        EffectTagDispatcher.setImmunityFor(MobBossValkyrie.class, (Tag[])new Tag[]{IMMUNE_TO_POISON});
        EffectTagDispatcher.setImmunityFor(MobFireMinion.class, (Tag[])new Tag[]{IMMUNE_TO_POISON});
        EffectTagDispatcher.setImmunityFor(MobBossSunspirit.class, (Tag[])new Tag[]{IMMUNE_TO_POISON});
    }

    private static void assignEffectRenderers() {
        EffectRendererDispatcher dispatcher = EffectRendererDispatcher.getInstance();
        dispatcher.addDispatch((Object)extraHealthEffect, (Object)new ExtraHealthEffectRenderer<Effect>(extraHealthEffect).setIcon(TextureRegistry.getTexture((NamespaceID)AetherItems.LIFESHARD.namespaceID)));
        dispatcher.addDispatch((Object)poisonEffect, (Object)new PoisonEffectRenderer<Effect>(poisonEffect, "/assets/aether/textures/other/poisonvignette.png", 8526027, "aether:gui/hud/poison/").setIcon("icon_poison.png"));
        dispatcher.addDispatch((Object)remedyEffect, (Object)new RemedyEffectRenderer<Effect>(remedyEffect, "/assets/aether/textures/other/curevignette.png", 39874, "aether:gui/hud/remedy/").setIcon("icon_remedy.png"));
    }

    public static void registerLock(Effect affected, Effect lock) {
        LookupLooks.instance.addEntry(affected, lock);
    }

    public static EffectStack resolveDominantEffect(Player player) {
        EffectStack dominant = null;
        EffectRendererDispatcher dispatcher = EffectRendererDispatcher.getInstance();
        for (EffectStack effectStack : ((IHasEffects)player).getContainer().getEffects()) {
            int dominantPotency;
            int effectStackPotency;
            if (!(dispatcher.getDispatch(effectStack.getEffect()) instanceof AetherCustomHeartContainer)) continue;
            if (dominant == null) {
                dominant = effectStack;
            }
            if ((effectStackPotency = effectStack.getAmount() * effectStack.getDuration()) <= (dominantPotency = dominant.getAmount() * dominant.getDuration())) continue;
            dominant = effectStack;
        }
        return dominant;
    }

    public static boolean add(Entity entity, Effect newEffect, int amount) {
        if (!(entity instanceof IHasEffects)) {
            return false;
        }
        EffectStack stack = new EffectStack((IHasEffects)entity, newEffect, amount);
        return AetherEffects.add(entity, stack);
    }

    public static boolean add(Entity entity, EffectStack stackToAdd) {
        if (!(entity instanceof IHasEffects)) {
            return false;
        }
        IHasEffects hasEffects = (IHasEffects)entity;
        for (EffectStack currStack : hasEffects.getContainer().getEffects()) {
            Effect currEffect = currStack.getEffect();
            int currMax = currEffect.getMaxStack();
            if (currEffect != stackToAdd.getEffect() || currStack.getAmount() + stackToAdd.getAmount() < currMax) continue;
            int amountToAdd = currMax - currStack.getAmount();
            currStack.add(amountToAdd, hasEffects.getContainer());
            return true;
        }
        if (AetherEffects.isLocked(stackToAdd, ((IHasEffects)entity).getContainer())) {
            return false;
        }
        stackToAdd.start(hasEffects.getContainer());
        hasEffects.getContainer().add(stackToAdd);
        return true;
    }

    public static <T> boolean isLocked(EffectStack effectStack, EffectContainer<T> effectContainer) {
        Effect effectBlocked = effectStack.getEffect();
        Effect effectBlocker = LookupLooks.instance.getLocker(effectBlocked);
        if (effectBlocker == null) {
            return false;
        }
        Object parent = effectContainer.getParent();
        if (parent instanceof IHasEffects && parent instanceof Mob && effectBlocker instanceof ILockInteractable && effectContainer.hasEffect(effectBlocker)) {
            ((ILockInteractable)effectBlocker).lockTriggered((IHasEffects)parent);
            effectContainer.remove(effectBlocked);
            return true;
        }
        return false;
    }

    static {
        IMMUNE_TO_POISON = Tag.of((String)"immune_to_poison");
    }

    public static class LookupLooks {
        public static final LookupLooks instance = new LookupLooks();
        public final Map<Effect, Effect> locker = new HashMap<Effect, Effect>();
        public final Map<Effect, HashSet<Effect>> lockedEffects = new HashMap<Effect, HashSet<Effect>>();

        public void addEntry(Effect getLocked, Effect lock) {
            this.locker.put(getLocked, lock);
            if (this.lockedEffects.containsKey(lock)) {
                HashSet<Effect> effects = this.lockedEffects.get(lock);
                effects.add(getLocked);
                return;
            }
            HashSet<Effect> effects = new HashSet<Effect>();
            effects.add(getLocked);
            this.lockedEffects.put(lock, effects);
        }

        @Nullable
        public Effect getLocker(Effect id) {
            return this.locker.getOrDefault(id, null);
        }

        @Nullable
        public HashSet<Effect> getLockedEffects(Effect id) {
            return this.lockedEffects.getOrDefault(id, null);
        }

        public Map<Effect, Effect> getLockerMap() {
            return this.locker;
        }

        public Map<Effect, HashSet<Effect>> getLockedEffectsMap() {
            return this.lockedEffects;
        }
    }
}

