/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.monster.cockatrice;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;
import teamport.aether.entity.monster.cockatrice.MobCockatrice;

@Environment(value=EnvType.CLIENT)
public class MobRendererCockatrice
extends MobRenderer<MobCockatrice> {
    public MobRendererCockatrice(ModelBase modelbase, float shadowSize) {
        super(modelbase, shadowSize);
        this.setArmorModel(modelbase);
    }

    public float limbSway(MobCockatrice entity, float partialTick) {
        float flap = entity.oFlap + (entity.flap - entity.oFlap) * partialTick;
        float flapSpeed = entity.oFlapSpeed + (entity.flapSpeed - entity.oFlapSpeed) * partialTick;
        return (MathHelper.sin((float)flap) + 1.0f) * flapSpeed;
    }

    public boolean setCockatriceGlowBrightness(MobCockatrice entity, int renderPass, float partialTick) {
        if (renderPass == 0) {
            this.bindTexture("/assets/aether/textures/entity/cockatrice/glow/" + entity.getTextureReference() + ".png");
            float brightness = entity.getBrightness(1.0f);
            if (LightmapHelper.isLightmapEnabled()) {
                LightmapHelper.setLightmapCoord((int)LightmapHelper.getLightmapCoord((int)15, (int)15));
            }
            float f1 = (1.0f - brightness) * 0.5f;
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3008);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f1);
            return true;
        }
        return false;
    }

    public void setupScale(MobCockatrice entity, float partialTick) {
        GL11.glScalef((float)1.8f, (float)1.8f, (float)1.8f);
    }

    public boolean prepareArmor(MobCockatrice entity, int renderPass, float partialTick) {
        return this.setCockatriceGlowBrightness(entity, renderPass, partialTick);
    }
}

