/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.accessory;

import com.mojang.nbt.tags.ListTag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import teamport.aether.items.accessory.IAccessoryEffects;

@Mixin(value={ContainerInventory.class}, remap=false)
public class ContainerInventoryMixinAccessory {
    @Shadow
    public Player player;
    @Shadow
    public ItemStack[] armorInventory;
    @Shadow
    public ItemStack[] mainInventory;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void setNewSize(Player player, CallbackInfo ci) {
        ((ContainerInventory)this).armorInventory = new ItemStack[8];
    }

    @ModifyConstant(method={"readFromNBT"}, constant={@Constant(intValue=4)}, require=1)
    public int modifyArmourSize(int original) {
        return 8;
    }

    @Inject(method={"readFromNBT"}, at={@At(value="TAIL")})
    public void activateAccessories(ListTag nbttaglist, CallbackInfo ci) {
        ContainerInventory inv = (ContainerInventory)this;
        for (ItemStack item : inv.armorInventory) {
            if (item != null && !(item.getItem() instanceof IAccessoryEffects)) continue;
        }
    }

    @ModifyConstant(method={"getContainerSize"}, constant={@Constant(intValue=4)}, require=1)
    public int modifyContainerSize(int original) {
        return this.armorInventory.length;
    }

    @Inject(method={"decrementAnimations"}, at={@At(value="TAIL")})
    public void addArmorAnimations(CallbackInfo ci) {
        ContainerInventory inv = (ContainerInventory)this;
        for (int slot = 0; slot < inv.armorInventory.length; ++slot) {
            if (inv.armorInventory[slot] == null) continue;
            inv.armorInventory[slot].updateAnimation(inv.player.world, (Entity)inv.player, slot + inv.mainInventory.length, inv.getCurrentItemIndex() == slot);
        }
    }

    @Inject(method={"removeItem"}, at={@At(value="HEAD")})
    public void updateEffects(int index, int takeAmount, CallbackInfoReturnable<ItemStack> cir) {
        if (index < this.mainInventory.length) {
            return;
        }
        ItemStack itemStack = this.armorInventory[index - this.mainInventory.length];
        if (itemStack != null && itemStack.getItem() instanceof IAccessoryEffects) {
            ((IAccessoryEffects)itemStack.getItem()).removeEffect(this.player, itemStack);
        }
    }

    @Inject(method={"setItem"}, at={@At(value="HEAD")})
    public void updateEffects(int index, ItemStack newItem, CallbackInfo ci) {
        if (index < this.mainInventory.length) {
            return;
        }
        ContainerInventory cont = (ContainerInventory)this;
        ItemStack oldItem = this.armorInventory[index - this.mainInventory.length];
        if (oldItem != null && oldItem.getItem() instanceof IAccessoryEffects) {
            ((IAccessoryEffects)oldItem.getItem()).removeEffect(this.player, oldItem);
        }
    }
}

