/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.item;

import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import teamport.aether.helper.ParticleHelper;
import teamport.aether.world.AetherDimension;

@Mixin(value={ItemBlock.class}, remap=false)
public abstract class ItemBlockBlacklistMixin {
    @Shadow
    @NotNull
    protected Block<?> block;
    @Unique
    private static final int[] BLOCK_TO_PLACE = new int[]{Blocks.PUMPKIN_CARVED_ACTIVE.id(), Blocks.BRAZIER_ACTIVE.id(), Blocks.PUMICE_WET.id(), Blocks.COBBLE_NETHERRACK_IGNEOUS.id()};
    @Unique
    private static final int[] BLOCK_TO_BECOME = new int[]{Blocks.PUMPKIN_CARVED_IDLE.id(), Blocks.BRAZIER_INACTIVE.id(), Blocks.PUMICE_DRY.id(), Blocks.COBBLE_NETHERRACK.id()};

    @Shadow
    public abstract int getPlacedBlockMetadata(@Nullable Player var1, ItemStack var2, World var3, int var4, int var5, int var6, Side var7, double var8, double var10);

    @Inject(method={"onUseItemOnBlock"}, at={@At(value="HEAD")}, cancellable=true)
    public void banBlocksFromDimensions(ItemStack stack, Player player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced, CallbackInfoReturnable<Boolean> cir) {
        Dimension dim = world.dimension;
        List<Integer> BLACKLIST = AetherDimension.getDimensionBlacklist(dim);
        if (BLACKLIST.contains(this.block.id())) {
            blockX += side.getOffsetX();
            blockY += side.getOffsetY();
            blockZ += side.getOffsetZ();
            if (dim == AetherDimension.AETHER) {
                for (int i = 0; i < BLOCK_TO_PLACE.length; ++i) {
                    if (this.block.id() != BLOCK_TO_PLACE[i]) continue;
                    int replacementId = BLOCK_TO_BECOME[i];
                    if (!world.canBlockBePlacedAt(replacementId, blockX, blockY, blockZ, false, side) || !stack.consumeItem(player)) break;
                    int meta = this.getPlacedBlockMetadata(player, stack, world, blockX, blockY, blockZ, side, xPlaced, yPlaced);
                    if (world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, replacementId, meta)) {
                        ParticleHelper.spawnReplacementEffects(world, blockX, blockY, blockZ);
                        if (player != null) {
                            this.block.onBlockPlacedByMob(world, blockX, blockY, blockZ, side, (Mob)player, xPlaced, yPlaced);
                        } else {
                            this.block.onBlockPlacedByWorld(world, blockX, blockY, blockZ);
                        }
                        world.playBlockSoundEffect((Entity)player, (double)((float)blockX + 0.5f), (double)((float)blockY + 0.5f), (double)((float)blockZ + 0.5f), this.block, EnumBlockSoundEffectType.PLACE);
                        cir.setReturnValue((Object)true);
                        return;
                    }
                    if (player != null && player.getGamemode().consumeBlocks()) {
                        ++stack.stackSize;
                    }
                    break;
                }
            } else {
                cir.setReturnValue((Object)false);
                return;
            }
            cir.setReturnValue((Object)false);
        }
    }
}

