/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.feature.chest;

import java.util.List;
import java.util.Random;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;
import teamport.aether.blocks.dungeon.BlockLogicChestLocked;
import teamport.aether.helper.AetherMathHelper;
import teamport.aether.world.feature.util.WorldFeatureComponent;

public class WorldFeatureAetherTreasureChest
extends WorldFeature {
    private final int chestMetadata;
    public int chestID;
    public WorldFeatureComponent.LootGenerator lootGenerator;
    public WeightedRandomBag<WeightedRandomLootObject> LOOT_RARE;
    public int guaranteedRare;

    public WorldFeatureAetherTreasureChest(int chestID, int chestMetadata, WorldFeatureComponent.LootGenerator lootGenerator, WeightedRandomBag<WeightedRandomLootObject> LOOT_RARE) {
        this.chestID = chestID;
        this.lootGenerator = lootGenerator;
        this.LOOT_RARE = LOOT_RARE;
        this.chestMetadata = chestMetadata;
    }

    public boolean place(World world, Random random, int ix, int iy, int iz) {
        Container inventory = BlockLogicChest.getInventory((World)world, (int)ix, (int)iy, (int)iz);
        Block block = world.getBlock(ix, iy, iz);
        if (block != null && inventory != null && block.getLogic() instanceof BlockLogicChestLocked) {
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                inventory.setItem(i, null);
            }
        }
        if (block == null || block.id() != this.chestID) {
            world.setBlockAndMetadataWithNotify(ix, iy, iz, this.chestID, this.chestMetadata);
        }
        this.setTreasure(world, random, ix, iy, iz);
        return true;
    }

    public void setTreasure(World world, Random random, int ix, int iy, int iz) {
        Container inventory = BlockLogicChest.getInventory((World)world, (int)ix, (int)iy, (int)iz);
        if (inventory == null) {
            return;
        }
        int quantity = AetherMathHelper.invertedExponentialCapped(random, 1.0f, 9);
        List<ItemStack> normalLoot = this.lootGenerator.generate(random);
        for (ItemStack stack : normalLoot) {
            WorldFeatureComponent.placeItemInChest(random, stack, inventory);
        }
        for (int i = 0; i < this.guaranteedRare + quantity; ++i) {
            WorldFeatureComponent.placeItemInChest(random, ((WeightedRandomLootObject)this.LOOT_RARE.getRandom()).getItemStack(random), inventory);
        }
    }
}

