/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util.io;

import com.mojang.nbt.tags.CompoundTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.UnmodifiableView;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.io.IItemStackList;
import sunsetsatellite.catalyst.core.util.io.ItemStackList;

public class InventoryWrapper
implements IItemStackList {
    public Container connected;

    public InventoryWrapper(Container inventory) {
        this.connected = inventory;
    }

    @Override
    public ItemStack add(ItemStack stack) {
        if (stack == null || this.connected == null) {
            return stack;
        }
        int n = stack.stackSize;
        for (int i = 0; i < this.connected.getContainerSize(); ++i) {
            ItemStack invStack = this.connected.getItem(i);
            if (invStack == null) {
                int amount = Math.min(stack.stackSize, stack.getMaxStackSize(this.connected));
                this.connected.setItem(i, stack.splitStack(amount));
                if ((n -= amount) > 0) continue;
                break;
            }
            if (!invStack.isItemEqual(stack)) continue;
            int remaining = Math.min(n, invStack.getMaxStackSize(this.connected) - invStack.stackSize);
            invStack.stackSize += remaining;
            if ((n -= remaining) <= 0) break;
        }
        if (n <= 0) {
            return null;
        }
        return new ItemStack(stack.itemID, n, stack.getMetadata(), stack.getData());
    }

    @Override
    public ItemStack add(int index, ItemStack stack) {
        if (stack == null || this.connected == null) {
            return stack;
        }
        ItemStack invStack = this.connected.getItem(index);
        if (invStack == null) {
            ItemStack split = stack.splitStack(Math.min(stack.stackSize, stack.getMaxStackSize(this.connected)));
            this.connected.setItem(index, split);
            return stack.stackSize <= 0 ? null : stack;
        }
        if (invStack.isItemEqual(stack)) {
            int remaining = Math.min(stack.stackSize, invStack.getMaxStackSize(this.connected) - invStack.stackSize);
            ItemStack split = stack.splitStack(remaining);
            invStack.stackSize += split.stackSize;
            return stack.stackSize <= 0 ? null : stack;
        }
        return stack;
    }

    @Override
    public @UnmodifiableView List<ItemStack> addAll(ItemStackList stacks) {
        return this.addAll(stacks.getStacks());
    }

    @Override
    public @UnmodifiableView List<ItemStack> addAll(List<ItemStack> stacks) {
        ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            newStacks.add(this.add(stack));
        }
        return Collections.unmodifiableList(Catalyst.condenseItemList(newStacks));
    }

    @Override
    public long getItemCapacity() {
        return this.connected != null ? (long)this.connected.getContainerSize() * (long)this.connected.getMaxStackSize() : 0L;
    }

    @Override
    public long getStackCapacity() {
        return this.getItemCapacity() / 64L;
    }

    @Override
    public long getStackAmount() {
        return this.getAmount() / 64L;
    }

    @Override
    public long getAmount() {
        return Catalyst.collectAndCondenseStacks(this.connected).stream().filter(Objects::nonNull).mapToInt(S -> S.stackSize).sum();
    }

    @Override
    public ItemStack remove(int slot, long amount, boolean strict, boolean unlimited) {
        if (this.connected == null) {
            return null;
        }
        List<ItemStack> stacks = Catalyst.collectStacks(this.connected);
        if (slot >= stacks.size()) {
            return null;
        }
        ItemStack stack = stacks.get(slot);
        if (stack == null) {
            return null;
        }
        if (strict && amount > (long)stack.stackSize) {
            return null;
        }
        if (!strict) {
            amount = Math.min(amount, (long)stack.stackSize);
            if (!unlimited) {
                amount = Math.min(amount, (long)stack.getItem().getItemStackLimit(stack));
            }
            ItemStack splitStack = stack.splitStack((int)amount);
            this.connected.setItem(slot, stack);
            if (stack.stackSize <= 0) {
                this.connected.setItem(slot, null);
            }
            this.inventoryChanged();
            return splitStack;
        }
        return null;
    }

    @Override
    public ItemStack remove(int slot, boolean strict, boolean unlimited) {
        List<ItemStack> stacks = Catalyst.collectStacks(this.connected);
        if (slot >= stacks.size()) {
            return null;
        }
        ItemStack stack = stacks.get(slot);
        if (stack == null) {
            return null;
        }
        return this.remove(slot, stack.getItem().getItemStackLimit(stack), strict, unlimited);
    }

    @Override
    public ItemStack remove(int id, int meta, long amount, CompoundTag data, boolean strict, boolean unlimited) {
        int index = this.find(id, meta, data);
        if (index != -1) {
            return this.remove(index, amount, strict, unlimited);
        }
        return null;
    }

    public ItemStack removeUntil(int id, int meta, long amount, CompoundTag data, boolean strict, boolean unlimited) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int actualAmount = 0;
        int index = this.find(id, meta, data);
        while ((long)actualAmount < amount && index != -1) {
            ItemStack stack = this.remove(index, amount - (long)actualAmount, strict, unlimited);
            if (stack != null) {
                stacks.add(stack);
                actualAmount += stack.stackSize;
            }
            index = this.find(id, meta, data);
        }
        return (stacks = Catalyst.condenseItemList(stacks)).isEmpty() ? null : (ItemStack)stacks.get(0);
    }

    @Override
    public boolean removeAll(List<ItemStack> stacks, boolean strict, boolean unlimited) {
        for (ItemStack stack : stacks) {
            ItemStack removed = this.remove(stack.itemID, stack.getMetadata(), stack.stackSize, stack.getData(), strict, unlimited);
            if (removed != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public @UnmodifiableView List<ItemStack> move(ItemStackList what, ItemStackList where, boolean strict) {
        return this.move(what.getStacks(), where, strict);
    }

    @Override
    public @UnmodifiableView List<ItemStack> move(List<ItemStack> what, ItemStackList where, boolean strict) {
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        for (ItemStack stack : what) {
            ItemStack removed = this.remove(stack.itemID, stack.getMetadata(), stack.stackSize, stack.getData(), strict, true);
            if (removed == null) {
                leftovers.add(stack);
                continue;
            }
            ItemStack addLeftover = where.add(removed);
            leftovers.add(addLeftover);
        }
        return Collections.unmodifiableList(Catalyst.condenseItemList(leftovers));
    }

    @Override
    public List<ItemStack> exportAll(List<ItemStack> stacks, boolean strict, boolean unlimited) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            ItemStack removed = this.remove(stack.itemID, stack.getMetadata(), stack.stackSize, stack.getData(), strict, unlimited);
            if (removed == null) continue;
            list.add(removed);
        }
        return list;
    }

    @Override
    public boolean eject(World world, int x, int y, int z, int slot, long amount, boolean strict) {
        ItemStack content = this.remove(slot, amount, strict, false);
        if (content != null) {
            float f = world.rand.nextFloat() * 0.8f + 0.1f;
            float f1 = world.rand.nextFloat() * 0.8f + 0.1f;
            float f2 = world.rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), content);
            float f3 = 0.05f;
            entityitem.xd = (float)world.rand.nextGaussian() * f3;
            entityitem.yd = (float)world.rand.nextGaussian() * f3 + 0.2f;
            entityitem.zd = (float)world.rand.nextGaussian() * f3;
            world.entityJoinedWorld((Entity)entityitem);
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean eject(World world, int x, int y, int z, int id, int meta, CompoundTag data, long amount, boolean strict) {
        ItemStack content = this.remove(id, meta, amount, data, strict, false);
        if (content != null) {
            float f = world.rand.nextFloat() * 0.8f + 0.1f;
            float f1 = world.rand.nextFloat() * 0.8f + 0.1f;
            float f2 = world.rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), content);
            float f3 = 0.05f;
            entityitem.xd = (float)world.rand.nextGaussian() * f3;
            entityitem.yd = (float)world.rand.nextGaussian() * f3 + 0.2f;
            entityitem.zd = (float)world.rand.nextGaussian() * f3;
            world.entityJoinedWorld((Entity)entityitem);
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    @Override
    public void ejectAll(World world, int x, int y, int z) {
        for (ItemStack content : this.getStacks()) {
            if (content == null) continue;
            this.eject(world, x, y, z, content.itemID, content.getMetadata(), content.getData(), content.stackSize, false);
        }
    }

    @Override
    public boolean contains(int id, int meta, CompoundTag data) {
        List<ItemStack> stacks = this.getStacks();
        return stacks.stream().anyMatch(stack -> stack.itemID == id && stack.getMetadata() == id);
    }

    @Override
    public boolean containsAtLeast(int id, int meta, CompoundTag data, long amount) {
        List<ItemStack> stacks = this.getStacks();
        return stacks.stream().anyMatch(stack -> stack.itemID == id && stack.getMetadata() == id && (long)stack.stackSize >= amount);
    }

    @Override
    public boolean containsAtLeast(List<ItemStack> comparedTo) {
        List<ItemStack> networkItems = this.getStacks();
        return networkItems.stream().filter(Objects::nonNull).anyMatch(networkStack -> comparedTo.stream().filter(Objects::nonNull).anyMatch(comparedToStack -> networkStack.isItemEqual(comparedToStack) && networkStack.stackSize >= comparedToStack.stackSize));
    }

    @Override
    public boolean containsAtLeast(ItemStackList stacks) {
        return this.containsAtLeast(stacks.getStacks());
    }

    @Override
    public ArrayList<ItemStack> returnMissing(ArrayList<ItemStack> stacks) {
        ArrayList<ItemStack> missing = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            long c = this.count(stack.itemID, stack.getMetadata(), stack.getData());
            if (c <= 0L) {
                missing.add(stack.copy());
                continue;
            }
            if (c == (long)stack.stackSize) continue;
            ItemStack copy = stack.copy();
            copy.stackSize -= (int)c;
            missing.add(stack.copy());
        }
        return missing;
    }

    @Override
    public long count(int id, int meta, CompoundTag data) {
        List<ItemStack> stacks = this.getStacks();
        return stacks.stream().filter(S -> S.itemID == id && S.getMetadata() == meta).mapToInt(S -> S.stackSize).sum();
    }

    @Override
    public long count(int id) {
        List<ItemStack> stacks = this.getStacks();
        return stacks.stream().filter(S -> S.itemID == id).mapToInt(S -> S.stackSize).sum();
    }

    @Override
    public int find(int id, int meta, CompoundTag data) {
        List<ItemStack> stacks = Catalyst.collectStacks(this.connected);
        for (int i = 0; i < stacks.size(); ++i) {
            if (stacks.get(i) == null || stacks.get((int)i).itemID != id || stacks.get(i).getMetadata() != meta && meta != -1 || !stacks.get(i).getData().equals((Object)data) && data != null) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ItemStack get(int index) {
        List<ItemStack> stacks = Catalyst.collectStacks(this.connected);
        if (index < 0 || index >= stacks.size()) {
            return null;
        }
        return stacks.get(index);
    }

    @Override
    public ItemStack get(int id, int meta, CompoundTag data) {
        return this.get(this.find(id, meta, data));
    }

    @Override
    public ItemStack getLast() {
        return this.getStacks().get(this.getStacks().size() - 1);
    }

    @Override
    public void inventoryChanged() {
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IItemStackList copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @UnmodifiableView List<ItemStack> getStacks() {
        return Catalyst.collectAndCondenseStacks(this.connected);
    }

    @Override
    public boolean isEmpty() {
        return this.getStacks().isEmpty();
    }
}

