/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util.mp;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import sunsetsatellite.catalyst.core.util.network.NetworkManager;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class PacketBlockNetworkData
implements NetworkMessage {
    public CompoundTag networks;
    public int dimension;

    public PacketBlockNetworkData(World world) {
        this.networks = new CompoundTag();
        this.dimension = world.dimension.id;
        NetworkManager.netsToTag(world, this.networks);
    }

    public PacketBlockNetworkData() {
    }

    public void encodeToUniversalPacket(@NotNull UniversalPacket packet) {
        packet.writeInt(this.dimension);
        packet.writeCompoundTag(this.networks);
    }

    public void decodeFromUniversalPacket(@NotNull UniversalPacket packet) {
        this.dimension = packet.readInt();
        this.networks = packet.readCompoundTag();
    }

    public void handle(NetworkMessage.NetworkContext context) {
        if (EnvironmentHelper.isClientWorld() && context.player.world != null && context.player.world.dimension.id == this.dimension) {
            NetworkManager.clearNets(context.player.dimension);
            NetworkManager.netsFromTag(context.player.world, this.networks);
        }
    }
}

