/*
 * Decompiled with CFR 0.152.
 */
package gungun974.solidpacket;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class BoundedInputStream
extends FilterInputStream {
    private int remaining;

    public BoundedInputStream(InputStream in, int length) {
        super(in);
        if (length < 0) {
            throw new IllegalArgumentException("Negative length");
        }
        this.remaining = length;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining <= 0) {
            return -1;
        }
        int b = this.in.read();
        if (b >= 0) {
            --this.remaining;
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.remaining <= 0) {
            return -1;
        }
        int toRead = Math.min(len, this.remaining);
        int n = this.in.read(b, off, toRead);
        if (n > 0) {
            this.remaining -= n;
        }
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        long toSkip = Math.min(n, (long)this.remaining);
        long s = this.in.skip(toSkip);
        if (s > 0L) {
            this.remaining = (int)((long)this.remaining - s);
        }
        return s;
    }

    public int getRemaining() {
        return this.remaining;
    }
}

