/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.index;

import java.util.List;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookPageManager;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.ScreenGuidebook;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.TextureManager;
import net.minecraft.core.lang.I18n;
import org.lwjgl.opengl.GL11;

public class GuidebookPageIndex
extends GuidebookPage {
    public static final int LINES_PER_PAGE = 14;
    private final List<Object> lines;
    private final int startIndex;
    private final int totalPages;

    public GuidebookPageIndex(GuidebookSection section, List<Object> lines, int startIndex) {
        super(section);
        this.lines = lines;
        this.startIndex = startIndex;
        this.totalPages = lines.size() / 2 / 14 + 1;
    }

    @Override
    protected void renderForeground(TextureManager re, Font fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int yOffset = 10;
        for (int i = this.startIndex; i < this.startIndex + 14 && i < this.lines.size() / 2; ++i) {
            boolean mouseOver;
            int j = i - this.startIndex;
            Object line = this.lines.get(i * 2);
            int pageNumber = (Integer)this.lines.get(i * 2 + 1) + this.totalPages;
            boolean bl = mouseOver = mouseX >= x + 8 && mouseX < x + 158 - 8 && mouseY >= y + yOffset + 10 + j * 12 - 2 && mouseY < y + yOffset + 10 + (j + 1) * 12 - 2;
            if (mouseOver) {
                this.drawRect(x + 8, y + yOffset + 10 + j * 12 - 2, x + 158 - 8, y + yOffset + 10 + (j + 1) * 12 - 2, Integer.MIN_VALUE);
            }
            String lineStr = "";
            String pageStr = String.valueOf(pageNumber);
            int pageStrWidth = fr.getStringWidth(pageStr);
            int lineXMod = 0;
            if (line instanceof GuidebookSection) {
                GuidebookSection section = (GuidebookSection)line;
                lineStr = I18n.getInstance().translateKey(section.getTranslationKey());
                this.drawStringNoShadow(fr, lineStr, x + 10, y + yOffset + 10 + j * 12, mouseOver ? 0xFFFFFF : 0x404040);
            } else if (line instanceof GuidebookSection.Index) {
                GuidebookSection.Index index = (GuidebookSection.Index)line;
                lineStr = index.getName();
                lineXMod = 16;
                this.drawStringNoShadow(fr, lineStr, x + 10 + lineXMod, y + yOffset + 10 + j * 12, mouseOver ? 0xFFFFFF : 0x606060);
            }
            this.drawStringNoShadow(fr, pageStr, x + 158 - 10 - pageStrWidth, y + yOffset + 10 + j * 12, mouseOver ? 0xFFFFFF : 0x404040);
            int lineStrWidth = fr.getStringWidth(lineStr);
            GL11.glDisable(3553);
            this.drawRect(x + 10 + lineStrWidth + 4 + lineXMod, y + yOffset + 10 + j * 12 + 6, x + 158 - 10 - pageStrWidth - 4, y + yOffset + 10 + j * 12 + 7, -6250336);
            GL11.glEnable(3553);
        }
    }

    @Override
    public void onMouseDown(int x, int y, int mouseX, int mouseY, int button) {
        super.onMouseDown(x, y, mouseX, mouseY, button);
        GuidebookPageManager guidebookPageManager = ScreenGuidebook.getPageManager();
        int yOffset = 10;
        for (int i = this.startIndex; i < this.startIndex + 14 && i < this.lines.size(); ++i) {
            boolean mouseOver;
            int j = i - this.startIndex;
            boolean bl = mouseOver = mouseX >= x + 8 && mouseX < x + 158 - 8 && mouseY >= y + yOffset + 10 + j * 12 - 2 && mouseY < y + yOffset + 10 + (j + 1) * 12 - 2;
            if (!mouseOver || i * 2 >= this.lines.size()) continue;
            Object line = this.lines.get(i * 2);
            if (line instanceof GuidebookSection) {
                GuidebookPageManager.searchQuery = null;
                guidebookPageManager.updatePages();
                guidebookPageManager.setCurrentPage(guidebookPageManager.getSectionIndex((GuidebookSection)line), true);
                return;
            }
            if (!(line instanceof GuidebookSection.Index)) continue;
            GuidebookPageManager.searchQuery = null;
            guidebookPageManager.updatePages();
            guidebookPageManager.setCurrentPage(guidebookPageManager.getPageIndex(((GuidebookSection.Index)line).getPage()), true);
            return;
        }
    }
}

