/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.index;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.GuidebookSections;
import net.minecraft.client.gui.guidebook.index.GuidebookPageIndex;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;

public class GuidebookSectionIndex
extends GuidebookSection {
    private ArrayList<GuidebookPage> allPages = null;
    private ArrayList<GuidebookPage> indexPages = null;

    public GuidebookSectionIndex() {
        super("guidebook.section.index", new ItemStack(Items.TOOL_COMPASS), 38143, 12753692);
    }

    @Override
    public List<GuidebookPage> getPages() {
        if (this.allPages == null) {
            this.initPages();
        }
        return this.indexPages;
    }

    private List<Object> getLines() {
        ArrayList<Object> lines = new ArrayList<Object>();
        int totalLines = 0;
        for (GuidebookSection section : GuidebookSections.getSectionList()) {
            if (section == GuidebookSections.COVER || section == GuidebookSections.INDEX) continue;
            lines.add(section);
            lines.add(this.allPages.indexOf(section.getPages().get(0)) + 1);
            ++totalLines;
            if (section.getIndices() == null) continue;
            for (GuidebookSection.Index index : section.getIndices()) {
                lines.add(index);
                lines.add(this.allPages.indexOf(index.getPage()) + 1);
                ++totalLines;
            }
        }
        int totalPages = totalLines / 14 + 1;
        lines.add(0, 1 - totalPages);
        lines.add(0, GuidebookSections.INDEX);
        return lines;
    }

    @Override
    public List<GuidebookSection.Index> getIndices() {
        return null;
    }

    private void initPages() {
        this.allPages = new ArrayList();
        for (GuidebookSection section : GuidebookSections.getSectionList()) {
            if (section == GuidebookSections.COVER || section == GuidebookSections.INDEX) continue;
            this.allPages.addAll(section.getPages());
        }
        this.indexPages = new ArrayList();
        List<Object> lines = this.getLines();
        int totalLines = lines.size() / 2;
        int totalPages = totalLines / 14 + 1;
        for (int i = 0; i < totalPages; ++i) {
            this.indexPages.add(new GuidebookPageIndex(this, lines, i * 14));
        }
    }
}

