/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.OptionFloat;
import net.minecraft.client.sound.SoundCategoryHelper;
import net.minecraft.client.sound.SoundEngine;
import net.minecraft.core.sound.SoundCategory;
import paulscode.sound.SoundSystem;

public class OptionVolume
extends OptionFloat {
    public final SoundCategory soundCategory;

    public OptionVolume(GameSettings gameSettings, String name, float value, SoundCategory soundCategory) {
        super(gameSettings, name, value);
        this.soundCategory = soundCategory;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.gameSettings.mc.sndManager.updateOptions();
        SoundSystem soundSystem = SoundEngine.getSoundSystem();
        if (soundSystem != null) {
            if (this.soundCategory != SoundCategory.GUI_SOUNDS && !soundSystem.playing("sound_audio_options")) {
                this.gameSettings.mc.sndManager.playSoundWithID(this.soundCategory.changedSound, this.soundCategory, 1.0f, 1.0f, "sound_audio_options");
            } else if (this.soundCategory != SoundCategory.GUI_SOUNDS) {
                soundSystem.setVolume("sound_audio_options", SoundCategoryHelper.getEffectiveVolume(this.soundCategory, this.gameSettings));
            }
        }
    }
}

