/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.piston.BlockLogicPistonBase;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class BlockModelPiston<T extends BlockLogicPistonBase>
extends BlockModelStandard<T> {
    private final IconCoordinate faceTexture;
    protected IconCoordinate sideTexture = TextureRegistry.getTexture("minecraft:block/piston/side");
    protected IconCoordinate topTexture = TextureRegistry.getTexture("minecraft:block/piston/top");
    protected IconCoordinate bottomTexture = TextureRegistry.getTexture("minecraft:block/piston/bottom");
    protected final double headThickness;
    private boolean headless = false;

    public BlockModelPiston(Block<T> block, IconCoordinate faceTexture) {
        this(block, faceTexture, 0.25);
    }

    public BlockModelPiston(Block<T> block, IconCoordinate faceTexture, double headThickness) {
        super(block);
        this.headThickness = headThickness;
        this.faceTexture = faceTexture;
    }

    public BlockModelPiston<T> setPistonTextures(IconCoordinate sideTexture, IconCoordinate topTexture, IconCoordinate bottomTexture) {
        this.sideTexture = sideTexture;
        this.topTexture = topTexture;
        this.bottomTexture = bottomTexture;
        return this;
    }

    public BlockModelPiston<T> setPistonTextures(String sideTexture, String topTexture, String bottomTexture) {
        return this.setPistonTextures(TextureRegistry.getTexture(sideTexture), TextureRegistry.getTexture(topTexture), TextureRegistry.getTexture(bottomTexture));
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        return this.renderPistonBase(tessellator, x, y, z, false);
    }

    public boolean renderHeadless(Tessellator tessellator, int x, int y, int z) {
        BlockModelPiston.renderBlocks.renderAllFaces = true;
        this.headless = true;
        boolean result = this.renderPistonBase(tessellator, x, y, z, true);
        this.headless = false;
        BlockModelPiston.renderBlocks.renderAllFaces = false;
        return result;
    }

    protected boolean renderPistonBase(Tessellator tessellator, int x, int y, int z, boolean noCulling) {
        int meta = BlockModelPiston.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        boolean extended = noCulling || (meta & 8) != 0;
        Direction direction = BlockLogicPistonBase.getDirection(meta);
        if (extended) {
            AABB bounds;
            switch (direction) {
                case DOWN: {
                    BlockModelPiston.renderBlocks.uvRotateEast = 3;
                    BlockModelPiston.renderBlocks.uvRotateWest = 3;
                    BlockModelPiston.renderBlocks.uvRotateSouth = 3;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 3;
                    bounds = AABB.getTemporaryBB(0.0, this.headThickness, 0.0, 1.0, 1.0, 1.0);
                    break;
                }
                case UP: {
                    bounds = AABB.getTemporaryBB(0.0, 0.0, 0.0, 1.0, 1.0 - this.headThickness, 1.0);
                    break;
                }
                case NORTH: {
                    BlockModelPiston.renderBlocks.uvRotateSouth = 1;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 2;
                    bounds = AABB.getTemporaryBB(0.0, 0.0, this.headThickness, 1.0, 1.0, 1.0);
                    break;
                }
                case SOUTH: {
                    BlockModelPiston.renderBlocks.uvRotateSouth = 2;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 1;
                    BlockModelPiston.renderBlocks.uvRotateTop = 3;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 3;
                    bounds = AABB.getTemporaryBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0 - this.headThickness);
                    break;
                }
                case WEST: {
                    BlockModelPiston.renderBlocks.uvRotateEast = 1;
                    BlockModelPiston.renderBlocks.uvRotateWest = 2;
                    BlockModelPiston.renderBlocks.uvRotateTop = 2;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 1;
                    bounds = AABB.getTemporaryBB(this.headThickness, 0.0, 0.0, 1.0, 1.0, 1.0);
                    break;
                }
                case EAST: {
                    BlockModelPiston.renderBlocks.uvRotateEast = 2;
                    BlockModelPiston.renderBlocks.uvRotateWest = 1;
                    BlockModelPiston.renderBlocks.uvRotateTop = 1;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 2;
                    bounds = AABB.getTemporaryBB(0.0, 0.0, 0.0, 1.0 - this.headThickness, 1.0, 1.0);
                    break;
                }
                default: {
                    bounds = AABB.getTemporaryBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                }
            }
            this.renderStandardBlock(tessellator, bounds, x, y, z);
            this.resetRenderBlocks();
        } else {
            switch (direction) {
                case DOWN: {
                    BlockModelPiston.renderBlocks.uvRotateEast = 3;
                    BlockModelPiston.renderBlocks.uvRotateWest = 3;
                    BlockModelPiston.renderBlocks.uvRotateSouth = 3;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 3;
                    break;
                }
                case NORTH: {
                    BlockModelPiston.renderBlocks.uvRotateSouth = 1;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 2;
                    break;
                }
                case SOUTH: {
                    BlockModelPiston.renderBlocks.uvRotateSouth = 2;
                    BlockModelPiston.renderBlocks.uvRotateNorth = 1;
                    BlockModelPiston.renderBlocks.uvRotateTop = 3;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 3;
                    break;
                }
                case WEST: {
                    BlockModelPiston.renderBlocks.uvRotateEast = 1;
                    BlockModelPiston.renderBlocks.uvRotateWest = 2;
                    BlockModelPiston.renderBlocks.uvRotateTop = 2;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 1;
                    break;
                }
                case EAST: {
                    BlockModelPiston.renderBlocks.uvRotateEast = 2;
                    BlockModelPiston.renderBlocks.uvRotateWest = 1;
                    BlockModelPiston.renderBlocks.uvRotateTop = 1;
                    BlockModelPiston.renderBlocks.uvRotateBottom = 2;
                }
            }
            this.renderStandardBlock(tessellator, this.block.getBounds(), x, y, z);
            this.resetRenderBlocks();
        }
        return true;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        super.renderBlockOnInventory(tessellator, 1, brightness, alpha, lightmapCoordinate);
    }

    public IconCoordinate getFaceTexture() {
        return this.faceTexture;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        Direction direction = BlockLogicPistonBase.getDirection(data);
        if (direction == Direction.NONE) {
            return this.blockTextures.get(Side.BOTTOM);
        }
        if (side.getDirection() == direction) {
            if (BlockLogicPistonBase.isPowered(data) || this.headless) {
                return this.topTexture;
            }
            return this.blockTextures.get(Side.BOTTOM);
        }
        return side.getDirection() != direction.getOpposite() ? this.sideTexture : this.bottomTexture;
    }
}

