/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.font;

import net.minecraft.client.render.font.Alignment;
import net.minecraft.client.render.font.Font;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.font.SF;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.util.helper.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RenderIntegerConstrainedBase {
    @NotNull
    protected FontRenderer fontRenderer;
    @NotNull
    protected Tessellator tessellator;
    @NotNull
    protected CharSequence chars;
    @NotNull
    protected Font font;
    protected int x;
    protected int y;
    protected double z;
    protected int maxWidth;
    protected int maxHeight;
    protected double @Nullable [] xPosBuffer;
    protected double @Nullable [] yPosBuffer;
    protected long @Nullable [] configBuffer;
    @NotNull
    protected Alignment alignment;
    protected long config;
    protected boolean shadow;
    protected boolean needCall;

    RenderIntegerConstrainedBase() {
    }

    @NotNull
    public RenderIntegerConstrainedBase init(@NotNull FontRenderer fontRenderer, @NotNull Tessellator tessellator, @NotNull CharSequence chars, int x, int y, int maxWidth, int maxHeight, double @Nullable [] xPosBuffer, double @Nullable [] yPosBuffer, long @Nullable [] configBuffer) {
        if (this.needCall) {
            throw new IllegalStateException("Init called before prior draw call!");
        }
        this.fontRenderer = fontRenderer;
        this.font = this.fontRenderer.getFont();
        this.tessellator = tessellator;
        this.chars = chars;
        this.x = x;
        this.y = y;
        this.z = 0.0;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.xPosBuffer = xPosBuffer;
        this.yPosBuffer = yPosBuffer;
        this.configBuffer = configBuffer;
        this.alignment = Alignment.LEFT;
        this.config = 0xFFFFFFFFL;
        this.shadow = false;
        this.needCall = true;
        return this;
    }

    @NotNull
    public RenderIntegerConstrainedBase setConfig(long config) {
        this.config = config;
        return this;
    }

    @NotNull
    public RenderIntegerConstrainedBase resetConfig() {
        this.config = 0xFFFFFFFFL;
        this.shadow = false;
        this.z = 0.0;
        return this;
    }

    @NotNull
    public RenderIntegerConstrainedBase setZ(double zLevel) {
        this.z = zLevel;
        return this;
    }

    @NotNull
    public RenderIntegerConstrainedBase setColor(@NotNull Color color) {
        this.config = SF.setColor(this.config, color.value);
        return this;
    }

    @NotNull
    public RenderIntegerConstrainedBase setColor(int argb) {
        this.config = SF.setColor(this.config, argb);
        return this;
    }

    @NotNull
    public RenderIntegerConstrainedBase setFont(@NotNull Font font) {
        this.font = font;
        return this;
    }

    @NotNull
    public RenderIntegerConstrainedBase setItalic() {
        this.config = SF.setItalic(this.config);
        return this;
    }

    @NotNull
    public RenderIntegerConstrainedBase setUnderline() {
        this.config = SF.setUnderline(this.config);
        return this;
    }

    @NotNull
    public RenderIntegerConstrainedBase setStrikethrough() {
        this.config = SF.setStrikethrough(this.config);
        return this;
    }

    @NotNull
    public RenderIntegerConstrainedBase setBold() {
        this.config = SF.setBold(this.config);
        return this;
    }

    @NotNull
    public RenderIntegerConstrainedBase setObfuscated() {
        this.config = SF.setObfuscated(this.config);
        return this;
    }

    @NotNull
    public RenderIntegerConstrainedBase setShadow() {
        this.shadow = true;
        return this;
    }

    @NotNull
    public RenderIntegerConstrainedBase setAlignment(@NotNull Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public abstract void call();
}

