/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texture.meta.gui;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.client.render.texture.meta.gui.GuiTextureProperties;

public class GuiTexturePropertiesAdapter
implements JsonDeserializer<GuiTextureProperties>,
JsonSerializer<GuiTextureProperties> {
    @Override
    public GuiTextureProperties deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jo = json.getAsJsonObject();
        JsonObject scalingObj = jo.getAsJsonObject("scaling");
        String type = "stretch";
        boolean stretchInner = false;
        int width = -1;
        int height = -1;
        GuiTextureProperties.Border border = null;
        if (scalingObj.has("type")) {
            type = scalingObj.get("type").getAsString();
        }
        if (type.equals("tile") || type.equals("nine_slice")) {
            if (!scalingObj.has("width")) {
                throw new JsonParseException("Gui scaling type 'tile' and 'nine_slice' requires a width property!");
            }
            if (!scalingObj.has("height")) {
                throw new JsonParseException("Gui scaling type 'tile' and 'nine_slice' requires a height property!");
            }
            width = scalingObj.get("width").getAsInt();
            height = scalingObj.get("height").getAsInt();
        }
        if (scalingObj.has("stretch_inner")) {
            stretchInner = scalingObj.get("stretch_inner").getAsBoolean();
        }
        if (type.equals("nine_slice")) {
            if (!scalingObj.has("border")) {
                throw new JsonParseException("Gui scaling type 'nine_slice' requires a border property!");
            }
            JsonElement be = scalingObj.get("border");
            if (be.isJsonPrimitive()) {
                border = new GuiTextureProperties.Border(be.getAsInt());
            } else if (be.isJsonObject()) {
                JsonObject borderObj = be.getAsJsonObject();
                border = new GuiTextureProperties.Border(borderObj.get("left").getAsInt(), borderObj.get("top").getAsInt(), borderObj.get("right").getAsInt(), borderObj.get("bottom").getAsInt());
            }
        }
        return new GuiTextureProperties(type, width, height, border, stretchInner);
    }

    @Override
    public JsonElement serialize(GuiTextureProperties src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject element = new JsonObject();
        element.addProperty("type", src.type);
        element.addProperty("width", src.width);
        element.addProperty("height", src.height);
        if (src.border.left == src.border.right && src.border.left == src.border.top && src.border.left == src.border.bottom) {
            element.addProperty("border", src.border.left);
        } else {
            JsonObject border = new JsonObject();
            border.addProperty("left", src.border.left);
            border.addProperty("top", src.border.top);
            border.addProperty("right", src.border.right);
            border.addProperty("bottom", src.border.bottom);
            element.add("border", border);
        }
        return element;
    }
}

