/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.helper.recipeBuilders;

import java.util.Objects;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryTrommel;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.ItemStack;
import turniplabs.halplibe.helper.RecipeBuilder;
import turniplabs.halplibe.helper.recipeBuilders.RecipeBuilderBase;

public class RecipeBuilderTrommel
extends RecipeBuilderBase {
    protected RecipeSymbol input;
    protected WeightedRandomBag<WeightedRandomLootObject> bag = new WeightedRandomBag();

    public RecipeBuilderTrommel(String modID) {
        super(modID);
    }

    public RecipeBuilderTrommel setInput(IItemConvertible item) {
        return this.setInput(item, 0);
    }

    public RecipeBuilderTrommel setInput(IItemConvertible item, int meta) {
        return this.setInput(new ItemStack(item, 1, meta));
    }

    public RecipeBuilderTrommel setInput(ItemStack input) {
        return this.setInput(new RecipeSymbol(input));
    }

    public RecipeBuilderTrommel setInput(String itemGroup) {
        return this.setInput(new RecipeSymbol(itemGroup));
    }

    public RecipeBuilderTrommel setInput(RecipeSymbol input) {
        RecipeBuilderTrommel builder = this.clone(this);
        builder.input = Objects.requireNonNull(input, "Input symbol must not be null!");
        return builder;
    }

    public RecipeBuilderTrommel addEntry(WeightedRandomLootObject lootObject, double weight) {
        RecipeBuilderTrommel builder = this.clone(this);
        builder.bag.addEntry((Object)lootObject, weight);
        return builder;
    }

    public void create(String recipeID) {
        Objects.requireNonNull(this.input, "Input symbol must not be null!");
        Objects.requireNonNull(this.bag, "Weighted Bag must not be null!");
        RecipeBuilder.getRecipeGroup(this.modID, "trommel", new RecipeSymbol(Blocks.TROMMEL_ACTIVE.getDefaultStack())).register(recipeID, (RecipeEntryBase)new RecipeEntryTrommel(this.input, this.bag));
    }

    @Override
    public void create(String recipeID, ItemStack outputStack) throws IllegalArgumentException {
        throw new IllegalArgumentException("Use create(String recipeID), create(String recipeID, ItemStack outputStack) does not apply for trommels");
    }
}

