/*
 * Decompiled with CFR 0.152.
 */
package gungun974.uselessnumerical;

import gungun974.uselessnumerical.MinecraftIdsConflict;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScrolledSelectionList;
import net.minecraft.client.player.controller.PlayerControllerSP;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.collection.NamespaceID;
import org.lwjgl.input.Keyboard;

public class MissingScreen
extends Screen {
    private final Screen textField;
    private final MinecraftIdsConflict saveConflict;
    private final String worldDirName;
    private final String worldName;
    private MissingList missingList;

    public MissingScreen(Screen guiscreen, MinecraftIdsConflict saveConflict, String worldDirName, String worldName) {
        this.textField = guiscreen;
        this.saveConflict = saveConflict;
        this.worldDirName = worldDirName;
        this.worldName = worldName;
    }

    public void init() {
        I18n i18n = I18n.getInstance();
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttons.clear();
        this.buttons.add(new ButtonElement(1, this.width / 2 + 4, this.height - 28, 150, 20, i18n.translateKey("gui.select_world.button.cancel")));
        this.buttons.add(new ButtonElement(2, this.width / 2 - 154, this.height - 28, 150, 20, "Keep loading"));
        this.missingList = new MissingList(this.saveConflict);
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void render(int mx, int my, float partialTick) {
        this.missingList.render(mx, my, partialTick);
        this.drawStringCentered(this.font, "Numerical IDs missing", this.width / 2, 20, 0xFFFFFF);
        this.drawStringCentered(this.font, "There are " + (this.saveConflict.localBlockMap.size() + this.saveConflict.localItemsMap.size()) + " missing blocks and items in this save.", this.width / 2, 40, 0xFFFFFF);
        this.drawStringCentered(this.font, "If you continue, the missing blocks/items will get removed.", this.width / 2, 60, 0xFFFFFF);
        super.render(mx, my, partialTick);
    }

    protected void buttonClicked(ButtonElement button) {
        if (button.enabled) {
            if (button.id == 1) {
                this.mc.displayScreen(this.textField);
            } else if (button.id == 2) {
                this.loadWorld();
            }
        }
    }

    public void loadWorld() {
        this.mc.displayScreen((Screen)null);
        this.mc.playerController = new PlayerControllerSP(this.mc);
        this.mc.startWorld(this.worldDirName, this.worldName, 0L);
        this.mc.displayScreen((Screen)null);
    }

    class MissingList
    extends ScrolledSelectionList {
        List<NamespaceID> missingLocalBlocks;
        List<NamespaceID> missingLocalItems;

        protected MissingList(MinecraftIdsConflict saveConflict) {
            super(MissingScreen.this.mc, MissingScreen.this.width + 124, MissingScreen.this.height, 76, MissingScreen.this.height - 38, 20);
            this.missingLocalBlocks = new ArrayList<NamespaceID>();
            this.missingLocalItems = new ArrayList<NamespaceID>();
            this.setRenderSelection(false);
            this.setRenderHeader(true, 8);
            for (Map.Entry<NamespaceID, Integer> block : saveConflict.localBlockMap.entrySet()) {
                this.missingLocalBlocks.add(block.getKey());
            }
            for (Map.Entry<NamespaceID, Integer> item : saveConflict.localItemsMap.entrySet()) {
                this.missingLocalItems.add(item.getKey());
            }
        }

        protected void selectItem(int itemIndex, boolean doubleClicked) {
        }

        protected boolean isSelectedItem(int itemIndex) {
            return false;
        }

        protected void renderHoleBackground() {
            MissingScreen.this.renderBackground();
        }

        protected final int getItemCount() {
            return this.missingLocalBlocks.size() + this.missingLocalItems.size();
        }

        protected void renderItem(int index, int x, int y, int height, Tessellator tessellator) {
            int blocksCount = this.missingLocalBlocks.size();
            int itemsCount = this.missingLocalItems.size();
            if (index < blocksCount) {
                NamespaceID block = this.missingLocalBlocks.get(index);
                MissingScreen.this.drawString(MissingScreen.this.font, "[Block]", x + 2 - 62 - 38, y + 1, index % 2 != 0 ? 0x909090 : 0xFFFFFF);
                MissingScreen.this.drawString(MissingScreen.this.font, block.toString(), x + 2 - 62, y + 1, index % 2 != 0 ? 0x909090 : 0xFFFFFF);
                return;
            }
            int itemIndex = index - blocksCount;
            if (itemIndex < itemsCount) {
                NamespaceID item = this.missingLocalItems.get(itemIndex);
                MissingScreen.this.drawString(MissingScreen.this.font, "[Item]", x + 2 - 62 - 38, y + 1, index % 2 != 0 ? 0x909090 : 0xFFFFFF);
                MissingScreen.this.drawString(MissingScreen.this.font, item.toString(), x + 2 - 62, y + 1, index % 2 != 0 ? 0x909090 : 0xFFFFFF);
            }
        }
    }
}

