/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether;

import java.io.IOException;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import teamport.aether.AetherMod;
import turniplabs.halplibe.util.TomlConfigHandler;
import turniplabs.halplibe.util.toml.Toml;

public class AetherConfig {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"aether");
    private static TomlConfigHandler cfg;
    public static final Object CONFIGURATION_LOCK;
    public static final String GeneralCategory = "General";
    public static int DIMENSION;
    public static int EXTRA_HEALTH;
    public static double QUICK_SOIL_SPEED_CAP;
    public static int ENCHANTER_SCREEN_ID;
    public static int FREEZER_SCREEN_ID;
    public static int INCUBATOR_SCREEN_ID;
    private static int BLOCK_ID_STARTING_FROM;
    private static int ITEM_ID_STARTING_FROM;
    public static int currentBlockID;
    public static int currentItemID;
    public static volatile String REMOTE_RESOURCE_URL;

    static String getDefaultRemoteUrl() {
        String result;
        FabricLoader loader = FabricLoader.getInstance();
        Optional modContainerOpt = loader.getModContainer("aether");
        if (loader.isDevelopmentEnvironment() || !modContainerOpt.isPresent()) {
            result = "https://raw.githubusercontent.com/bta-team-port/better-with-aether/refs/heads/7.3/remoteAssets/";
        } else {
            ModContainer modContainer = (ModContainer)modContainerOpt.get();
            String version = modContainer.getMetadata().getVersion().getFriendlyString().substring(0, 5);
            if (version.endsWith(".0")) {
                version = version.substring(0, 3);
            }
            result = String.format("https://raw.githubusercontent.com/bta-team-port/better-with-aether/refs/tags/%s-" + AetherMod.state + "/remoteAssets/", version);
        }
        return result;
    }

    static void Setup() {
        LOGGER.info("Initializing config..");
        Toml props = new Toml("Aether Configs.toml");
        AetherConfig.assembleProperties(props);
        cfg = new TomlConfigHandler("aether", props);
        if (cfg.getConfigFile().exists()) {
            cfg.loadConfig();
        } else {
            try {
                cfg.getConfigFile().createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            cfg.writeConfig();
        }
        AetherConfig.loadProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties() {
        DIMENSION = AetherConfig.cfgGetValueOrDefault("General.DIMENSION", DIMENSION);
        EXTRA_HEALTH = AetherConfig.cfgGetValueOrDefault("General.EXTRA_HEALTH", EXTRA_HEALTH);
        QUICK_SOIL_SPEED_CAP = AetherConfig.cfgGetValueOrDefault("General.QUICK_SOIL_SPEED_CAP", QUICK_SOIL_SPEED_CAP);
        ENCHANTER_SCREEN_ID = AetherConfig.cfgGetValueOrDefault("General.ENCHANTER_SCREEN_ID", ENCHANTER_SCREEN_ID);
        FREEZER_SCREEN_ID = AetherConfig.cfgGetValueOrDefault("General.FREEZER_SCREEN_ID", FREEZER_SCREEN_ID);
        INCUBATOR_SCREEN_ID = AetherConfig.cfgGetValueOrDefault("General.INCUBATOR_SCREEN_ID", INCUBATOR_SCREEN_ID);
        currentBlockID = BLOCK_ID_STARTING_FROM = AetherConfig.cfgGetValueOrDefault("General.BLOCK_ID_STARTING_FROM", BLOCK_ID_STARTING_FROM).intValue();
        currentItemID = ITEM_ID_STARTING_FROM = AetherConfig.cfgGetValueOrDefault("General.ITEM_ID_STARTING_FROM", ITEM_ID_STARTING_FROM).intValue();
        Object object = CONFIGURATION_LOCK;
        synchronized (object) {
            REMOTE_RESOURCE_URL = AetherConfig.cfgGetValueOrDefault("General.REMOTE_RESOURCE_URL", REMOTE_RESOURCE_URL);
        }
        if (!REMOTE_RESOURCE_URL.endsWith("/")) {
            LOGGER.error("Remote resource URL lacks trailing slash!");
        }
    }

    private static void assembleProperties(Toml properties) {
        properties.addCategory(GeneralCategory).addEntry("cfgVersion", (Object)6).addEntry("DIMENSION", (Object)DIMENSION).addEntry("EXTRA_HEALTH", (Object)EXTRA_HEALTH).addEntry("QUICK_SOIL_SPEED_CAP", (Object)QUICK_SOIL_SPEED_CAP).addEntry("REMOTE_RESOURCE_URL", (Object)REMOTE_RESOURCE_URL).addEntry("ENCHANTER_SCREEN_ID", (Object)ENCHANTER_SCREEN_ID).addEntry("FREEZER_SCREEN_ID", (Object)FREEZER_SCREEN_ID).addEntry("INCUBATOR_SCREEN_ID", (Object)INCUBATOR_SCREEN_ID).addEntry("BLOCK_ID_STARTING_FROM", (Object)BLOCK_ID_STARTING_FROM).addEntry("ITEM_ID_STARTING_FROM", (Object)ITEM_ID_STARTING_FROM);
    }

    public static int itemID(String itemName) {
        return currentItemID++;
    }

    public static int blockID(String blockName) {
        return currentBlockID++;
    }

    static <T> T cfgGetValueOrDefault(String key, T def) {
        Object res;
        block8: {
            res = null;
            try {
                if (def instanceof String) {
                    res = cfg.getString(key);
                    break block8;
                }
                if (def instanceof Integer) {
                    res = cfg.getInt(key);
                    break block8;
                }
                if (def instanceof Long) {
                    res = cfg.getLong(key);
                    break block8;
                }
                if (def instanceof Boolean) {
                    res = cfg.getBoolean(key);
                    break block8;
                }
                if (def instanceof Double || def instanceof Float) {
                    double raw = cfg.getDouble(key);
                    res = def instanceof Float ? (Number)Float.valueOf((float)raw) : (Number)raw;
                    break block8;
                }
                throw new RuntimeException("Invalid value type!");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (res == null) {
            LOGGER.warn("Failed to load \"{}\"! Assuming default...", (Object)key);
            return def;
        }
        return (T)res;
    }

    static {
        CONFIGURATION_LOCK = new Object();
        DIMENSION = 9;
        EXTRA_HEALTH = 20;
        QUICK_SOIL_SPEED_CAP = 1.325f;
        ENCHANTER_SCREEN_ID = 12;
        FREEZER_SCREEN_ID = 13;
        INCUBATOR_SCREEN_ID = 14;
        BLOCK_ID_STARTING_FROM = 10000;
        ITEM_ID_STARTING_FROM = 26000;
        REMOTE_RESOURCE_URL = AetherConfig.getDefaultRemoteUrl();
    }
}

