/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.blocks.machine;

import java.util.Random;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicRotatable;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.entity.tile.TileEntityFreezer;
import teamport.aether.gui.AetherScreens;
import teamport.aether.helper.ParticleMaker;

public class BlockLogicFreezer
extends BlockLogicRotatable {
    public final boolean isActive;
    public static boolean keepFreezerInventory = false;

    public BlockLogicFreezer(Block<?> block, boolean active) {
        super(block, Material.stone);
        this.isActive = active;
        block.withEntity(TileEntityFreezer::new);
    }

    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case PICK_BLOCK: 
            case EXPLOSION: 
            case PROPER_TOOL: 
            case SILK_TOUCH: 
            case PISTON_CRUSH: {
                return new ItemStack[]{new ItemStack(AetherBlocks.FREEZER_IDLE)};
            }
        }
        return null;
    }

    public void animationTick(World world, int x, int y, int z, Random rand) {
        if (this.isActive) {
            double poxX = (double)x + 0.5;
            double posY = (double)y + 1.0 + (double)(rand.nextFloat() * 6.0f / 16.0f);
            double posZ = (double)z + 0.5;
            for (int i = 0; i < 3; ++i) {
                double maxSpeedX = rand.nextGaussian() * 0.05;
                double maxSpeedZ = rand.nextGaussian() * 0.05;
                ParticleMaker.spawnParticle(world, "snowshovel", poxX, posY, posZ, maxSpeedX, 0.05f, maxSpeedZ, 0);
            }
        }
    }

    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (!world.isClientSide) {
            TileEntityFreezer tileEntityFreezer = (TileEntityFreezer)world.getTileEntity(x, y, z);
            ((AetherScreens)player).aether$displayFreezerScreen(tileEntityFreezer);
        }
        return true;
    }

    public static void updateFurnaceBlockState(boolean lit, @NotNull World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (tileEntity == null) {
            String msg = "Freezer is missing Tile Entity at x: " + x + " y: " + y + " z: " + z + ", block will be removed!";
            if (Global.BUILD_CHANNEL.isUnstableBuild()) {
                throw new RuntimeException(msg);
            }
            world.setBlockWithNotify(x, y, z, 0);
            return;
        }
        keepFreezerInventory = true;
        if (lit) {
            world.setBlockWithNotify(x, y, z, AetherBlocks.FREEZER_ACTIVE.id());
        } else {
            world.setBlockWithNotify(x, y, z, AetherBlocks.FREEZER_IDLE.id());
        }
        keepFreezerInventory = false;
        world.setBlockMetadataWithNotify(x, y, z, meta);
        tileEntity.validate();
        world.setTileEntity(x, y, z, tileEntity);
    }
}

