/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.blocks.skyroot;

import java.util.function.Supplier;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicDoor;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.item.Item;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import teamport.aether.blocks.skyroot.BlockLogicPaintedDoor;

public class BlockLogicPaintableDoor
extends BlockLogicDoor {
    protected final Block<? extends BlockLogicPaintedDoor> paintedDoorBlockBottom;
    protected final Block<? extends BlockLogicPaintedDoor> paintedDoorBlockTop;

    public BlockLogicPaintableDoor(Block<?> block, Material material, boolean isTop, boolean requireTool, Block<? extends BlockLogicPaintedDoor> paintedDoorBlockTop, Block<? extends BlockLogicPaintedDoor> paintedDoorBlockBottom, @Nullable Supplier<Item> droppedItem) {
        super(block, material, isTop, requireTool, droppedItem);
        this.paintedDoorBlockBottom = paintedDoorBlockBottom;
        this.paintedDoorBlockTop = paintedDoorBlockTop;
    }

    public boolean canBePainted() {
        return true;
    }

    public void setColor(World world, int x, int y, int z, DyeColor color) {
        int meta = world.getBlockMetadata(x, y, z);
        if (this.isTop) {
            world.setBlockAndMetadataRaw(x, y, z, this.paintedDoorBlockTop.id(), meta);
            ((BlockLogicPaintedDoor)this.paintedDoorBlockTop.getLogic()).setColor(world, x, y, z, color);
            world.setBlockAndMetadataRaw(x, y - 1, z, this.paintedDoorBlockBottom.id(), meta);
            ((BlockLogicPaintedDoor)this.paintedDoorBlockBottom.getLogic()).setColor(world, x, y - 1, z, color);
        } else {
            world.setBlockAndMetadataRaw(x, y, z, this.paintedDoorBlockBottom.id(), meta);
            ((BlockLogicPaintedDoor)this.paintedDoorBlockBottom.getLogic()).setColor(world, x, y, z, color);
            world.setBlockAndMetadataRaw(x, y + 1, z, this.paintedDoorBlockTop.id(), meta);
            ((BlockLogicPaintedDoor)this.paintedDoorBlockTop.getLogic()).setColor(world, x, y + 1, z, color);
        }
    }
}

