/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.compat.waila;

import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.TextFormatting;
import teamport.aether.entity.tile.TileEntityFreezer;
import toufoumaster.btwaila.BTWaila;
import toufoumaster.btwaila.gui.components.AdvancedInfoComponent;
import toufoumaster.btwaila.tooltips.TileTooltip;
import toufoumaster.btwaila.util.ProgressBarOptions;
import toufoumaster.btwaila.util.TextureOptions;

public class FreezerTooltip
extends TileTooltip<TileEntityFreezer> {
    public void initTooltip() {
        this.addClass(TileEntityFreezer.class);
    }

    public void drawAdvancedTooltip(TileEntityFreezer freezer, AdvancedInfoComponent advancedInfoComponent) {
        ItemStack input = freezer.getItem(0);
        ItemStack fuel = freezer.getItem(1);
        ItemStack output = freezer.getItem(2);
        ProgressBarOptions options = new ProgressBarOptions(0, String.format("%s%s%s ", TextFormatting.LIGHT_BLUE, BTWaila.translator.translateKey("aether.tooltip.freezer.progress"), TextFormatting.RESET), true, true, new TextureOptions(0xFFFFFF, TextureRegistry.getTexture((String)"aether:extras/freezer_bg")), new TextureOptions(0xFFFFFF, TextureRegistry.getTexture((String)"aether:extras/freezer_fg")));
        advancedInfoComponent.drawProgressBarTextureWithText(freezer.getProcessProgressScaled(100), 100, options, 0);
        advancedInfoComponent.drawStringWithShadow(String.format(BTWaila.translator.translateKey("aether.tooltip.machine.energy"), freezer.currentEnergyTime / 20), 0);
        ItemStack[] stacks = new ItemStack[]{input, fuel, output};
        advancedInfoComponent.drawItemList(stacks, 0);
    }
}

