/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.effect;

import java.util.List;
import java.util.Random;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.Direction;
import sunsetsatellite.catalyst.effects.api.effect.Effect;
import sunsetsatellite.catalyst.effects.api.effect.EffectContainer;
import sunsetsatellite.catalyst.effects.api.effect.EffectStack;
import sunsetsatellite.catalyst.effects.api.effect.EffectTimeType;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;
import sunsetsatellite.catalyst.effects.api.modifier.Modifier;
import teamport.aether.AetherMod;
import teamport.aether.effect.AetherEffects;
import teamport.aether.helper.ParticleMaker;

public class PoisonEffect
extends Effect {
    public final Random random = new Random();
    public double rotD;
    public double motD;

    public PoisonEffect(String nameKey, String id, List<Modifier<?>> modifiers, EffectTimeType effectTimeType, int maxStack) {
        super(nameKey, id, modifiers, effectTimeType, maxStack);
    }

    public <T> void activated(EffectStack effectStack, EffectContainer<T> effectContainer) {
        if (!this.canApplyTo((Entity)effectContainer.getParent())) {
            return;
        }
        if (AetherEffects.isLocked(effectStack, effectContainer)) {
            return;
        }
        if (effectStack.getAmount() == 1) {
            ((Mob)effectContainer.getParent()).hurt(null, 1, DamageType.GENERIC);
        }
    }

    public <T> void expired(EffectStack effectStack, EffectContainer<T> effectContainer) {
        effectContainer.remove(AetherEffects.poisonEffect);
        EffectStack newStack = new EffectStack((IHasEffects)effectContainer.getParent(), AetherEffects.poisonEffect, effectStack.getAmount() - 1);
        newStack.start(effectContainer);
        effectContainer.add(newStack);
        assert (effectContainer.getParent() instanceof Mob);
        ((Mob)effectContainer.getParent()).hurt(null, 1, DamageType.GENERIC);
    }

    public <T> void tick(EffectStack effectStack, EffectContainer<T> effectContainer) {
        if (!(effectContainer.getParent() instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)effectContainer.getParent();
        if (mob.world == null) {
            AetherMod.LOGGER.warn("PoisonEffect is not applied cause the world is null");
            return;
        }
        if (mob.tickCount % 4 == 0) {
            if (mob instanceof Player) {
                Direction dir = Direction.getDirection((Mob)mob).getOpposite();
                ParticleMaker.spawnPoisonParticles(mob.world, mob.x + (double)dir.getOffsetX(), mob.y - 2.0, mob.z + (double)dir.getOffsetZ(), mob.bbHeight, mob.bbWidth);
            } else {
                ParticleMaker.spawnPoisonParticles(mob.world, mob.x, mob.y, mob.z, mob.bbHeight, mob.bbWidth);
            }
        }
        this.slideEntity(mob);
    }

    public boolean canApplyTo(Entity target) {
        return target instanceof Mob && super.canApplyTo(target);
    }

    private void slideEntity(Mob mob) {
        double gauss = this.random.nextGaussian();
        double newMotD = 0.1 * gauss;
        this.motD = 0.2 * newMotD + 0.8 * this.motD;
        mob.xd += this.motD;
        mob.zd += this.motD;
        double newRotD = 0.7853981633974483 * gauss;
        this.rotD = 0.125 * newRotD + 0.875 * this.rotD;
        mob.yRot = (float)((double)mob.yRot + this.rotD);
        mob.xRot = (float)((double)mob.xRot + this.rotD);
    }

    public <T> void stackAdded(EffectStack effectStack, EffectContainer<T> effectContainer) {
        ((Mob)effectContainer.getParent()).hurt(null, 1, DamageType.GENERIC);
        super.stackAdded(effectStack, effectContainer);
    }
}

