/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.animal.aerbunny;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.client.Minecraft;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.MobMonster;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketSetRiding;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.World;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import teamport.aether.entity.AetherRideable;
import teamport.aether.entity.animal.MobAetherAnimal;
import teamport.aether.helper.ParticleMaker;
import teamport.aether.items.AetherItemTags;
import teamport.aether.mixin.accessors.EntityAccessor;
import teamport.aether.net.message.AetherRideableNetworkMessage;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class MobAerbunny
extends MobAetherAnimal
implements AetherRideable {
    public boolean grab;

    public MobAerbunny(World world) {
        super(world);
        this.setSize(0.4f, 0.4f);
        this.textureIdentifier = NamespaceID.getPermanent((String)"aether", (String)"aerbunny");
        this.mobDrops.add(new WeightedRandomLootObject(Items.STRING.getDefaultStack(), 1));
    }

    public boolean isFavouriteItem(ItemStack itemStack) {
        return itemStack != null && itemStack.itemID < Blocks.blocksList.length && Blocks.blocksList[itemStack.itemID].hasTag(BlockTags.SHEEPS_FAVOURITE_BLOCK) || itemStack != null && itemStack.getItem().hasTag(AetherItemTags.NATURE_STAFF_FOLLOW);
    }

    public int getMaxHealth() {
        return 4;
    }

    public double getRidingHeight() {
        if (EnvironmentHelper.isClientWorld() && this.vehicle != Minecraft.getMinecraft().thePlayer) {
            return this.heightOffset + 0.5f;
        }
        return this.heightOffset - 1.1f;
    }

    protected void defineSynchedData() {
        this.entityData.define(20, (Object)0, Integer.class);
    }

    public float getPuffiness() {
        return Float.intBitsToFloat(this.entityData.getInt(20));
    }

    public void setPuffiness(float val) {
        this.entityData.set(20, (Object)Float.floatToIntBits(val));
    }

    @Override
    public void controlEntity(float moveForward, float moveStrafe, boolean isJumping, float xRot, float yRot) {
        if (EnvironmentHelper.isClientWorld()) {
            NetworkHandler.sendToServer((NetworkMessage)new AetherRideableNetworkMessage(moveForward, moveStrafe, isJumping, xRot, yRot));
        }
        Entity vehicle = (Entity)this.vehicle;
        assert (vehicle != null);
        if (vehicle.yd < (double)-0.225f && isJumping && !vehicle.noPhysics) {
            vehicle.yd = 0.125;
            this.cloudPoop();
            this.setPuffiness(1.15f);
        }
    }

    public void tick() {
        float puffiness = this.getPuffiness();
        puffiness = puffiness > 0.0f ? (puffiness -= 0.1f) : 0.0f;
        this.setPuffiness(puffiness);
        if (this.vehicle != null) {
            if (this.vehicle.isRemoved()) {
                this.startRiding(this.vehicle);
            }
        } else if (!this.grab) {
            int z;
            int y;
            int x;
            if (this.moveForward != 0.0f && (this.world.getBlockId(x = MathHelper.floor((double)this.x), (y = MathHelper.floor((double)this.bb.minY)) - 1, z = MathHelper.floor((double)this.z)) != 0 || this.world.getBlockId(x, y - 2, z) != 0) && this.world.getBlockId(x, y + 1, z) == 0 && this.world.getBlockId(x, y + 2, z) == 0) {
                if (this.yd < 0.0) {
                    this.cloudPoop();
                    this.setPuffiness(0.9f);
                }
                this.yd = 0.2;
            }
            if (this.yd < -0.1) {
                this.yd = -0.1;
            }
        }
        if (this.vehicle instanceof Player) {
            Player player = (Player)this.vehicle;
            if (!player.onGround && !player.noPhysics) {
                if (!player.isInWater()) {
                    player.yd += (double)0.05f;
                }
                ((EntityAccessor)player).setFallDistance(0.0f);
            }
            player.handleSpecialVehicleControl();
            player.sendSpecialVehiclePacket();
        }
        super.tick();
    }

    public void causeFallDamage(float distance) {
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    public void onLivingUpdate() {
        if (this.onGround && this.moveForward != 0.0f) {
            this.jump();
            this.setPuffiness(1.15f);
            this.cloudPoop();
        }
        if (this.grab && this.onGround) {
            this.grab = false;
            this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.aerbunny.land", 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            for (Entity entity : this.world.getEntitiesWithinAABBExcludingEntity((Entity)this, this.bb.expand(12.0, 12.0, 12.0))) {
                if (!(entity instanceof MobMonster)) continue;
                ((MobMonster)entity).setTarget((Entity)this);
            }
        }
        if (this.isInWater()) {
            this.jump();
        }
        super.onLivingUpdate();
    }

    public void cloudPoop() {
        double factor = this.random.nextFloat() - 0.5f;
        double x = this.x + factor * (double)0.4f;
        double y = this.bb.minY;
        double z = this.z + factor * (double)0.4f;
        if (EnvironmentHelper.isServerEnvironment() && this.vehicle != null) {
            y += (double)((Player)this.vehicle).bbHeight;
        }
        ParticleMaker.spawnParticle(this.world, "explode", x, y, z, 0.0, -0.075f, 0.0, 0);
    }

    public boolean hurt(Entity entity, int i, DamageType type) {
        if (this.vehicle != null) {
            return false;
        }
        return super.hurt(entity, i, type);
    }

    public boolean interact(@NotNull Player player) {
        if (player.isSneaking()) {
            return super.interact(player);
        }
        if (this.vehicle == player) {
            this.grab = false;
            this.vehicle.ejectRider();
            return true;
        }
        if (player.getPassenger() instanceof MobAerbunny) {
            return false;
        }
        this.startRiding((IVehicle)player);
        this.grab = true;
        this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.aerbunny.lift", 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        this.isJumping = false;
        return true;
    }

    public String getLivingSound() {
        return "aether:mob.aerbunny.lift";
    }

    public String getHurtSound() {
        return "aether:mob.aerbunny.hurt";
    }

    public String getDeathSound() {
        return "aether:mob.aerbunny.death";
    }

    public void startRiding(IVehicle vehicle) {
        super.startRiding(vehicle);
        if (EnvironmentHelper.isServerEnvironment()) {
            MinecraftServer.getInstance().playerList.sendPacketToPlayersAroundPoint(this.x, this.y, this.z, 32.0, this.world.dimension.id, (Packet)new PacketSetRiding((Entity)this, (Entity)this.vehicle));
        }
    }
}

