/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.animal.phow;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.util.helper.MathHelper;
import teamport.aether.entity.animal.phow.MobPhow;
import teamport.aether.entity.animal.phow.ModelPhow;

@Environment(value=EnvType.CLIENT)
public class MobRendererPhow
extends MobRenderer<MobPhow> {
    public MobRendererPhow(ModelBase modelbase, float shadowSize) {
        super(modelbase, shadowSize);
        this.setArmorModel(modelbase);
    }

    public float limbSway(MobPhow cow, float partialTick) {
        float wingFold = MathHelper.lerp((float)cow.wingFoldO, (float)cow.wingFold, (float)partialTick);
        float wingAngle = MathHelper.lerp((float)cow.wingAngleO, (float)cow.wingAngle, (float)partialTick);
        float wingBend = -((float)Math.acos(wingFold));
        float x = 32.0f * wingFold / 4.0f;
        float y = -32.0f * (float)Math.sqrt(1.0f - wingFold * wingFold) / 4.0f;
        float z = 0.0f;
        float x2 = x * (float)Math.cos(wingAngle) - y * (float)Math.sin(wingAngle);
        float y2 = x * (float)Math.sin(wingAngle) + y * (float)Math.cos(wingAngle);
        ModelPhow.leftWingInner.setRotationPoint(4.0f + x2, y2 + 6.0f, z);
        ModelPhow.rightWingInner.setRotationPoint(-4.0f - x2, y2 + 6.0f, z);
        x2 = (x *= 3.0f) * (float)Math.cos(wingAngle) - y * (float)Math.sin(wingAngle);
        y2 = x * (float)Math.sin(wingAngle) + y * (float)Math.cos(wingAngle);
        ModelPhow.leftWingOuter.setRotationPoint(4.0f + x2, y2 + 6.0f, z);
        ModelPhow.rightWingOuter.setRotationPoint(-4.0f - x2, y2 + 6.0f, z);
        ModelPhow.leftWingInner.zRot = wingAngle + wingBend + 1.5707964f;
        ModelPhow.leftWingOuter.zRot = wingAngle - wingBend + 1.5707964f;
        ModelPhow.rightWingInner.zRot = -(wingAngle + wingBend - 1.5707964f);
        ModelPhow.rightWingOuter.zRot = -(wingAngle - wingBend + 1.5707964f);
        return wingBend;
    }

    public boolean renderSaddledPhow(MobPhow entity, int i, float f) {
        this.bindTexture("/assets/aether/textures/entity/phow/phow_saddle.png");
        return i == 0 && entity != null && entity.getSaddled();
    }

    public boolean prepareArmor(MobPhow entity, int renderPass, float partialTick) {
        return this.renderSaddledPhow(entity, renderPass, partialTick);
    }
}

