/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.animal.sheepuff;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelQuadruped;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.MathHelper;
import teamport.aether.entity.animal.sheepuff.MobSheepuff;

@Environment(value=EnvType.CLIENT)
public class ModelSheepuffWool
extends ModelQuadruped {
    boolean isEatingAnimPlaying;
    float headBobTime;

    public ModelSheepuffWool() {
        super(12, 0.0f);
        this.head = new Cube(0, 0);
        this.head.addBox(-3.0f, -4.0f, -4.0f, 6, 6, 6, 0.6f);
        this.head.setRotationPoint(0.0f, 6.0f, -8.0f);
        this.body = new Cube(28, 8);
        this.body.addBox(-4.0f, -10.0f, -7.0f, 8, 16, 6, 1.75f);
        this.body.setRotationPoint(0.0f, 5.0f, 2.0f);
        float f = 0.5f;
        this.leg1 = new Cube(0, 16);
        this.leg1.addBox(-2.0f, 0.0f, -2.0f, 4, 6, 4, f);
        this.leg1.setRotationPoint(-3.0f, 12.0f, 7.0f);
        this.leg2 = new Cube(0, 16);
        this.leg2.addBox(-2.0f, 0.0f, -2.0f, 4, 6, 4, f);
        this.leg2.setRotationPoint(3.0f, 12.0f, 7.0f);
        this.leg3 = new Cube(0, 16);
        this.leg3.addBox(-2.0f, 0.0f, -2.0f, 4, 6, 4, f);
        this.leg3.setRotationPoint(-3.0f, 12.0f, -5.0f);
        this.leg4 = new Cube(0, 16);
        this.leg4.addBox(-2.0f, 0.0f, -2.0f, 4, 6, 4, f);
        this.leg4.setRotationPoint(3.0f, 12.0f, -5.0f);
    }

    public void setupAnimation(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        super.setupAnimation(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        float desiredRotateAngleX = headPitch / 57.29578f;
        float desiredRotateAngleY = headYaw / 57.29578f;
        if (this.isEatingAnimPlaying) {
            if (this.headBobTime < 5.0f) {
                float partPercentage = this.headBobTime / 5.0f;
                this.head.xRot = desiredRotateAngleX * (1.0f - partPercentage) + 1.0472f * partPercentage;
                this.head.yRot = desiredRotateAngleY * (1.0f - partPercentage);
            } else if (this.headBobTime < 35.0f) {
                this.head.xRot = 1.0472f;
                this.head.yRot = 0.0f;
            } else if (this.headBobTime < 40.0f) {
                float partPercentage = (this.headBobTime - 35.0f) / 5.0f;
                this.head.xRot = desiredRotateAngleX * partPercentage + 1.0472f * (1.0f - partPercentage);
                this.head.yRot = desiredRotateAngleY * partPercentage;
            }
        } else {
            this.head.xRot = desiredRotateAngleX;
            this.head.yRot = desiredRotateAngleY;
        }
    }

    public void setLivingAnimations(Mob mob, float limbSwing, float limbYaw, float partialTick) {
        MobSheepuff entitySheep = (MobSheepuff)mob;
        this.head.y = 6.0f;
        this.isEatingAnimPlaying = false;
        if (entitySheep.getIsSheepEating()) {
            this.headBobTime = (float)entitySheep.prevTimeSheepEating + (float)(entitySheep.timeSheepEating - entitySheep.prevTimeSheepEating) * partialTick;
            this.isEatingAnimPlaying = true;
            if (this.headBobTime < 5.0f) {
                this.head.y = 6.0f + 2.0f * (this.headBobTime + 1.0f);
            } else if (this.headBobTime < 35.0f) {
                this.head.y = 16.0f + MathHelper.sin((float)(this.headBobTime * 0.05f * 30.5f)) / 3.0f;
            } else if (this.headBobTime < 40.0f) {
                this.head.y = 16.0f - 2.0f * (this.headBobTime - 34.0f);
            }
        } else {
            this.headBobTime = 0.0f;
        }
    }
}

