/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.boss;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.IntTag;
import com.mojang.nbt.tags.StringTag;
import com.mojang.nbt.tags.Tag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.MobPathfinder;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import teamport.aether.AetherMod;
import teamport.aether.entity.AetherDeathMessage;
import teamport.aether.entity.boss.EnemyBoss;
import teamport.aether.helper.NameGenerator;
import teamport.aether.world.feature.util.WorldFeaturePoint;
import teamport.aether.world.feature.util.map.DungeonMap;
import turniplabs.halplibe.helper.EnvironmentHelper;

public abstract class MobBoss
extends MobPathfinder
implements EnemyBoss,
AetherDeathMessage {
    @Nullable
    public Integer dungeonID = null;
    public String bossName = NameGenerator.getRandomName();
    @Nullable
    public WorldFeaturePoint returnPoint = null;
    protected boolean hasHadReturnPointSet = false;
    @Nullable
    public ItemStack trophy = null;

    public MobBoss(@Nullable World world) {
        super(world);
    }

    @Override
    public boolean canFight() {
        return this.isAlive();
    }

    @Override
    public void setTrophy(@Nullable ItemStack itemStack) {
        this.trophy = itemStack;
    }

    @Override
    @Nullable
    public ItemStack getTrophy() {
        return this.trophy;
    }

    @Override
    public void setDungeonID(int id) {
        this.dungeonID = id;
    }

    @Override
    public String getBossTitle() {
        String translationKey = EntityDispatcher.nameKeyForClass(this.getClass());
        return String.format(AetherMod.TRANSLATOR.translateKey(translationKey + ".title"), this.getBossName());
    }

    @Override
    public String getBossName() {
        return this.bossName;
    }

    public boolean canDespawn() {
        return false;
    }

    public void onDeath(Entity entityKilledBy) {
        assert (this.world != null);
        AetherMod.LOGGER.info(this.bossName + " of ID " + this.dungeonID + " has been slain!");
        if (this.trophy != null) {
            if (!EnvironmentHelper.isClientWorld()) {
                this.world.dropItem((int)this.x, (int)this.y, (int)this.z, this.trophy);
            }
            this.world.playBlockEvent(null, 1003, (int)this.x, (int)this.y, (int)this.z, 0);
        }
        if (this.dungeonID != null) {
            DungeonMap.runWithDungeon(this.dungeonID, d -> d.notifyBossDead(this));
        }
        for (int x1 = -3; x1 < 3; ++x1) {
            for (int z1 = -3; z1 < 3; ++z1) {
                for (int y1 = -3; y1 < 3; ++y1) {
                    this.world.notifyBlockChange((int)this.x + x1, (int)this.y + y1, (int)this.z + z1, this.world.getBlockId((int)this.x + x1, (int)this.y + y1, (int)this.z + z1));
                }
            }
        }
        super.onDeath(entityKilledBy);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        this.dungeonID = tag.getInteger("dungeonID");
        this.bossName = tag.getString("bossName");
        CompoundTag trophyNBT = tag.getCompound("trophy");
        if (trophyNBT != null) {
            this.trophy = ItemStack.readItemStackFromNbt((CompoundTag)trophyNBT);
        }
        if (tag.getBoolean("hasHadReturnPointSet")) {
            CompoundTag returnPointNBT = tag.getCompound("returnPoint");
            this.returnPoint = WorldFeaturePoint.fromCompoundTag(returnPointNBT);
            this.hasHadReturnPointSet = true;
        } else {
            this.returnPoint = null;
        }
        super.readAdditionalSaveData(tag);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        tag.put("bossName", (Tag)new StringTag(this.bossName));
        if (this.dungeonID != null) {
            tag.put("dungeonID", (Tag)new IntTag(this.dungeonID.intValue()));
        }
        if (this.returnPoint != null) {
            tag.put("returnPoint", (Tag)this.returnPoint.toCompoundTag());
            tag.putBoolean("hasHadReturnPointSet", true);
        }
        if (this.trophy != null) {
            CompoundTag trophyNBT = new CompoundTag();
            this.trophy.writeToNBT(trophyNBT);
            tag.put("trophy", (Tag)trophyNBT);
        }
        super.addAdditionalSaveData(tag);
    }

    @Override
    public void returnToHome() {
        if (this.returnPoint == null || !this.hasHadReturnPointSet) {
            return;
        }
        this.moveTo(this.returnPoint.x, this.returnPoint.y, this.returnPoint.z, 0.0f, 0.0f);
    }

    @Override
    public void setReturnPoint(@Nullable WorldFeaturePoint returnPoint) {
        this.returnPoint = returnPoint;
        this.hasHadReturnPointSet = true;
    }

    @Override
    public String deathMessage(Player player) {
        String key = EntityDispatcher.nameKeyForClass(this.getClass()) + ".death_message";
        String name = key + "_" + this.random.nextInt(9);
        String bossName = TextFormatting.BOLD.toString() + TextFormatting.get((int)this.chatColor).toString() + this.getBossTitle() + TextFormatting.RESET + TextFormatting.RED;
        String playerName = player.getDisplayName() + TextFormatting.RESET + TextFormatting.RED;
        String deathMessage = AetherMod.TRANSLATOR.translateKey(name).replace("[PLAYER]", playerName).replace("[BOSS]", bossName);
        return TextFormatting.RED + deathMessage;
    }

    public void returnToOriginalState() {
        this.target = null;
        this.returnToHome();
        DungeonMap.runWithDungeon(this.dungeonID, d -> d.unlock(this, this.world));
        this.setHealthRaw(this.getMaxHealth());
    }
}

