/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.monster.cockatrice;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.data.tag.ITaggable;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.monster.Enemy;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import teamport.aether.blocks.AetherBlockTags;
import teamport.aether.entity.AetherDeathMessage;
import teamport.aether.entity.monster.MobMonsterAether;
import teamport.aether.entity.projectile.ProjectileNeedle;

public class MobCockatrice
extends MobMonsterAether
implements Enemy,
AetherDeathMessage {
    public float flap = 0.0f;
    public float flapSpeed = 0.0f;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;

    public MobCockatrice(@Nullable World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"aether", (String)"cockatrice");
        this.setSize(1.0f, 2.0f);
        this.mobDrops.add(new WeightedRandomLootObject(Items.FEATHER_CHICKEN.getDefaultStack(), 0, 2));
        this.scoreValue = 500;
    }

    public void tick() {
        super.tick();
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(this.onGround ? -1 : 4) * 0.3);
        if (this.flapSpeed < 0.0f) {
            this.flapSpeed = 0.0f;
        }
        if (this.flapSpeed > 1.0f) {
            this.flapSpeed = 1.0f;
        }
        if (!this.onGround && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        if (!this.onGround && this.yd < 0.0) {
            this.yd *= 0.6;
        }
        this.flap += this.flapping * 2.0f;
    }

    public void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(15, (Object)this.attackTime, Integer.class);
    }

    public void onLivingUpdate() {
        if (this.world.isClientSide) {
            this.attackTime = this.entityData.getInt(15);
        } else {
            this.entityData.set(15, (Object)this.attackTime);
        }
        super.onLivingUpdate();
    }

    public void attackEntity(@NotNull Entity entity, float distance) {
        if (distance < 10.0f) {
            double d = entity.x - this.x;
            double d1 = entity.z - this.z;
            if (this.attackTime == 0) {
                if (!this.world.isClientSide) {
                    ProjectileNeedle needle = new ProjectileNeedle(this.world, (Mob)this);
                    double d2 = entity.y + (double)entity.getHeadHeight() - 0.8 - needle.y;
                    float f1 = MathHelper.sqrt((double)(d * d + d1 * d1)) * 0.2f;
                    this.world.playSoundAtEntity(null, (Entity)this, "random.bow", 0.3f, 2.0f / (this.random.nextFloat() * 0.4f + 0.8f));
                    needle.setHeading(d, d2 + (double)f1, d1, 0.6f, 12.0f);
                    this.world.entityJoinedWorld((Entity)needle);
                }
                this.attackTime = 30;
            }
            this.yRot = (float)(Math.atan2(d1, d) * 180.0 / Math.PI) - 90.0f;
            this.hasAttacked = true;
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    public void jump() {
        this.yd = 0.6;
    }

    public void causeFallDamage(float distance) {
    }

    public int getAmbientSoundInterval() {
        return 240;
    }

    public String getLivingSound() {
        return "aether:mob.moa";
    }

    public String getHurtSound() {
        return "aether:mob.moa";
    }

    public String getDeathSound() {
        return "aether:mob.moa";
    }

    public void playLivingSound() {
        this.world.playSoundAtEntity(null, (Entity)this, this.getLivingSound(), 0.5f, (this.random.nextFloat() - this.random.nextFloat()) * 0.5f + 0.25f);
    }

    public void playHurtSound() {
        this.world.playSoundAtEntity(null, (Entity)this, this.getHurtSound(), 0.5f, (this.random.nextFloat() - this.random.nextFloat()) * 0.5f + 0.25f);
    }

    public void playDeathSound() {
        this.world.playSoundAtEntity(null, (Entity)this, this.getDeathSound(), 0.5f, (this.random.nextFloat() - this.random.nextFloat()) * 0.5f + 0.25f);
    }

    @Override
    public boolean canSpawnHere() {
        int blockZ;
        int blockY;
        int blockX = MathHelper.floor((double)this.x);
        if (this.world.getSavedLightValue(LightLayer.Block, blockX, blockY = MathHelper.floor((double)this.bb.minY), blockZ = MathHelper.floor((double)this.z)) > 7) {
            return false;
        }
        if (this.world.getSavedLightValue(LightLayer.Sky, blockX, blockY, blockZ) > this.random.nextInt(32)) {
            return false;
        }
        int blockLight = this.world.getBlockLightValue(blockX, blockY, blockZ);
        if (this.world.getCurrentWeather() != null && this.world.getCurrentWeather().doMobsSpawnInDaylight) {
            blockLight /= 2;
        }
        return blockLight <= 4 && AetherBlockTags.PASSIVE_MOBS_SPAWN.appliesTo((ITaggable)this.world.getBlock(MathHelper.floor((double)this.x), MathHelper.floor((double)(this.y - (double)this.heightOffset)) - 1, MathHelper.floor((double)this.z))) && super.canSpawnHere();
    }
}

