/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.monster.fireminion;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.Enemy;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import teamport.aether.entity.AetherDeathMessage;
import teamport.aether.entity.monster.MobMonsterAether;
import teamport.aether.helper.ParticleMaker;
import turniplabs.halplibe.helper.EnvironmentHelper;

public class MobFireMinion
extends MobMonsterAether
implements Enemy,
AetherDeathMessage {
    public MobFireMinion(@Nullable World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"aether", (String)"fire_minion");
        this.moveSpeed = 4.0f;
        this.attackStrength = 10;
        this.fireImmune = true;
        this.maxFireTicks = 20;
        this.scoreValue = 5000;
        this.setSize(1.0f, 2.5f);
        this.canBreatheUnderwater();
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    public float getBrightness(float partialTick) {
        return 1.0f;
    }

    public int getLightmapCoord(float partialTick) {
        return this.world.getLightmapCoord(15, 15);
    }

    public int getMaxHealth() {
        return 40;
    }

    protected void attackEntity(@NotNull Entity entity, float distance) {
        if (this.attackTime <= 0 && distance < 2.0f && entity.bb.maxY > this.bb.minY && entity.bb.minY < this.bb.maxY) {
            this.attackTime = 20;
            entity.hurt((Entity)this, this.attackStrength, DamageType.FIRE);
            entity.hurt((Entity)this, this.attackStrength / 2, DamageType.COMBAT);
            entity.remainingFireTicks = 300;
            entity.maxFireTicks = 300;
        }
    }

    protected Entity findPlayerToAttack() {
        Player entityplayer = this.world.getClosestPlayerToEntity((Entity)this, 16.0);
        return entityplayer != null && this.canEntityBeSeen((Entity)entityplayer) && entityplayer.getGamemode().areMobsHostile() ? entityplayer : null;
    }

    @Override
    public boolean hurt(Entity attacker, int i, DamageType type) {
        if (type == DamageType.FIRE) {
            return false;
        }
        return super.hurt(attacker, i, type);
    }

    public void tick() {
        super.tick();
        if (this.getHealth() > 0) {
            this.maxFireTicks = 20;
            for (int j = 0; j < 4; ++j) {
                double a = this.random.nextFloat() - 0.5f;
                double b = this.random.nextFloat();
                double c = this.random.nextFloat() - 0.5f;
                double d = this.x + a * b;
                double e = this.bb.minY + b - 0.5;
                double f = this.z + c * b;
                if (EnvironmentHelper.isServerEnvironment()) continue;
                ParticleMaker.spawnParticle(this.world, "flame", d, e, f, 0.0, -0.075f, 0.0, 0);
            }
        }
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        return "aether:mob.sunspirit.hurt";
    }

    public String getDeathSound() {
        return "aether:mob.sunspirit.death";
    }

    public void playHurtSound() {
        this.world.playSoundAtEntity(null, (Entity)this, this.getHurtSound(), 0.5f, (this.random.nextFloat() + this.random.nextFloat()) * 1.5f + 0.25f);
    }

    public void playDeathSound() {
        this.world.playSoundAtEntity(null, (Entity)this, this.getDeathSound(), 0.5f, (this.random.nextFloat() + this.random.nextFloat()) * 1.5f + 0.25f);
    }
}

