/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.monster.swet;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.Enemy;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import teamport.aether.entity.monster.swet.MobSwet;
import teamport.aether.helper.ParticleMaker;
import teamport.aether.items.AetherItems;

public class MobSwetGold
extends MobSwet
implements Enemy {
    public MobSwetGold(World world) {
        super(world);
        this.heightOffset = 0.0f;
        this.scoreValue = 400;
        this.setPos(this.x, this.y, this.z);
        this.jumpDelay = 20;
        this.textureIdentifier = NamespaceID.getPermanent((String)"aether", (String)"swet_gold");
        this.moveSpeed = 3.0f;
        this.mobDrops.add(new WeightedRandomLootObject(Blocks.GLOWSTONE.getDefaultStack(), 0));
    }

    @Override
    public List<WeightedRandomLootObject> getMobDrops() {
        ArrayList<WeightedRandomLootObject> drops = new ArrayList<WeightedRandomLootObject>();
        drops.add(new WeightedRandomLootObject(Blocks.GLOWSTONE.getDefaultStack(), 1, 2));
        return drops;
    }

    @Override
    public int getMaxHealth() {
        return 26;
    }

    @Override
    public void jump() {
        this.yd = this.passenger != null ? 1.8 : 0.8;
    }

    public float getBrightness(float partialTick) {
        return 1.0f;
    }

    public int getLightmapCoord(float partialTick) {
        return this.world.getLightmapCoord(15, 15);
    }

    @Override
    public void doTickEffect() {
        if (this.random.nextInt(2) == 0) {
            ParticleMaker.spawnParticle(this.world, "arrowtrail", this.x, this.y, this.z, this.xd * 0.05, this.yd * 0.05 - 0.1, this.zd * 0.05, 0);
            ParticleMaker.spawnParticle(this.world, "arrowtrail", this.x + this.xd * 0.5, this.y + this.yd * 0.5, this.z + this.zd * 0.5, this.xd * 0.05, this.yd * 0.05 - 0.1, this.zd * 0.05, 0);
        }
    }

    @Override
    public Item getBounceParticle() {
        return AetherItems.FOOD_GUMMY_GOLD;
    }

    @Override
    public void attackEntity(@NotNull Entity entity, float distance) {
        if (this.isAlive() && !this.friendly && this.attackTime <= 0 && distance < 2.0f && entity.bb.maxY > this.bb.minY && entity.bb.minY < this.bb.maxY && this.getHealth() > 0 && !this.dead) {
            this.attackTime = 200;
            this.world.playSoundAtEntity(null, (Entity)this, "mob.slimeattack", 0.5f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            entity.hurt((Entity)this, 3, DamageType.COMBAT);
        }
    }

    @Override
    public void playerTouch(Player player) {
        if (this.isAlive() && !this.friendly && this.canEntityBeSeen((Entity)player) && (double)this.distanceTo((Entity)player) < 2.0 && player.hurt((Entity)this, 3, DamageType.COMBAT) && this.getHealth() > 0 && !this.dead && this.grabDelay == 0) {
            player.startRiding((IVehicle)this);
            this.grabDelay = 50;
        }
    }
}

