/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.monster.valkyrie;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelBiped;
import net.minecraft.core.util.helper.MathHelper;

@Environment(value=EnvType.CLIENT)
public class ModelValkyrie
extends ModelBiped {
    public Cube bipedBody2;
    public Cube bipedRightArm2;
    public Cube bipedLeftArm2;
    public Cube wingLeft;
    public Cube wingRight;
    public Cube[] skirt;
    public Cube[] strand;
    public Cube halo;
    public float sinage;
    public boolean gonRound;

    public ModelValkyrie() {
        this(0.0f);
    }

    public ModelValkyrie(float expandAmount) {
        this.Cubes(0.0f);
    }

    public void Cubes(float expandAmount) {
        this.holdingLeftHand = false;
        this.holdingRightHand = false;
        this.sneaking = false;
        this.head = new Cube(0, 0);
        this.head.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8, expandAmount);
        this.head.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.body = new Cube(12, 16);
        this.body.addBox(-3.0f, 0.0f, -1.5f, 6, 12, 3, expandAmount);
        this.body.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.bipedBody2 = new Cube(12, 16);
        this.bipedBody2.addBox(-3.0f, 0.5f, -1.25f, 6, 5, 3, expandAmount + 0.75f);
        this.bipedBody2.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.armRight = new Cube(30, 16);
        this.armRight.addBox(-2.0f, -1.5f, -1.5f, 3, 12, 3, expandAmount);
        this.armRight.setRotationPoint(-4.0f, 1.5f, 0.0f);
        this.armLeft = new Cube(30, 16);
        this.armLeft.mirror = true;
        this.armLeft.addBox(-1.0f, -1.5f, -1.5f, 3, 12, 3, expandAmount);
        this.armLeft.setRotationPoint(5.0f, 1.5f, 0.0f);
        this.bipedRightArm2 = new Cube(52, 11);
        this.bipedRightArm2.addBox(-3.0f, -1.5f, -1.5f, 3, 3, 3, expandAmount + 0.75f);
        this.bipedRightArm2.setRotationPoint(-4.0f, 1.5f, 0.0f);
        this.bipedLeftArm2 = new Cube(52, 11);
        this.bipedLeftArm2.mirror = true;
        this.bipedLeftArm2.addBox(-1.0f, -1.5f, -1.5f, 3, 3, 3, expandAmount + 0.75f);
        this.bipedLeftArm2.setRotationPoint(5.0f, 1.5f, 0.0f);
        this.legRight = new Cube(0, 16);
        this.legRight.addBox(-2.0f, 0.0f, -1.5f, 3, 12, 3, expandAmount);
        this.legRight.setRotationPoint(-1.0f, 12.0f, 0.0f);
        this.legLeft = new Cube(0, 16);
        this.legLeft.mirror = true;
        this.legLeft.addBox(-2.0f, 0.0f, -1.5f, 3, 12, 3, expandAmount);
        this.legLeft.setRotationPoint(2.0f, 12.0f, 0.0f);
        this.wingLeft = new Cube(24, 31);
        this.wingLeft.addBox(0.0f, -4.5f, 0.0f, 19, 8, 1, expandAmount);
        this.wingLeft.setRotationPoint(0.5f, 1.5f, 2.625f);
        this.wingRight = new Cube(24, 31);
        this.wingRight.mirror = true;
        this.wingRight.addBox(-19.0f, -4.5f, 0.0f, 19, 8, 1, expandAmount);
        this.wingRight.setRotationPoint(-0.5f, 1.5f, 2.625f);
        this.skirt = new Cube[6];
        this.skirt[0] = new Cube(0, 0);
        this.skirt[0].addBox(0.0f, 0.0f, -1.0f, 3, 6, 0, expandAmount);
        this.skirt[0].setRotationPoint(-3.0f, 9.0f, -0.5f);
        this.skirt[1] = new Cube(0, 0);
        this.skirt[1].addBox(0.0f, 0.0f, -1.0f, 3, 6, 0, expandAmount);
        this.skirt[1].setRotationPoint(0.0f, 9.0f, -0.5f);
        this.skirt[2] = new Cube(0, 0);
        this.skirt[2].addBox(0.0f, 0.0f, 0.0f, 3, 6, 0, expandAmount);
        this.skirt[2].setRotationPoint(-3.0f, 9.0f, 1.5f);
        this.skirt[3] = new Cube(0, 0);
        this.skirt[3].addBox(0.0f, 0.0f, 0.0f, 3, 6, 0, expandAmount);
        this.skirt[3].setRotationPoint(0.0f, 9.0f, 1.5f);
        this.skirt[4] = new Cube(55, 19);
        this.skirt[4].addBox(-1.0f, 0.0f, 0.0f, 0, 6, 3, expandAmount);
        this.skirt[4].setRotationPoint(-2.0f, 9.0f, -1.5f);
        this.skirt[5] = new Cube(55, 19);
        this.skirt[5].addBox(0.0f, 0.0f, 0.0f, 0, 6, 3, expandAmount);
        this.skirt[5].setRotationPoint(3.0f, 9.0f, -1.5f);
        this.strand = new Cube[22];
        for (int i = 0; i < 22; ++i) {
            this.strand[i] = new Cube(42 + i % 7, 17);
        }
        this.strand[0].addBox(-5.0f, -7.0f, -4.0f, 1, 3, 1, expandAmount);
        this.strand[0].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[1].addBox(4.0f, -7.0f, -4.0f, 1, 3, 1, expandAmount);
        this.strand[1].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[2].addBox(-5.0f, -7.0f, -3.0f, 1, 4, 1, expandAmount);
        this.strand[2].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[3].addBox(4.0f, -7.0f, -3.0f, 1, 4, 1, expandAmount);
        this.strand[3].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[4].addBox(-5.0f, -7.0f, -2.0f, 1, 4, 1, expandAmount);
        this.strand[4].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[5].addBox(4.0f, -7.0f, -2.0f, 1, 4, 1, expandAmount);
        this.strand[5].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[6].addBox(-5.0f, -7.0f, -1.0f, 1, 5, 1, expandAmount);
        this.strand[6].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[7].addBox(4.0f, -7.0f, -1.0f, 1, 5, 1, expandAmount);
        this.strand[7].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[8].addBox(-5.0f, -7.0f, 0.0f, 1, 5, 1, expandAmount);
        this.strand[8].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[9].addBox(4.0f, -7.0f, 0.0f, 1, 5, 1, expandAmount);
        this.strand[9].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[10].addBox(-5.0f, -7.0f, 1.0f, 1, 6, 1, expandAmount);
        this.strand[10].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[11].addBox(4.0f, -7.0f, 1.0f, 1, 6, 1, expandAmount);
        this.strand[11].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[12].addBox(-5.0f, -7.0f, 2.0f, 1, 7, 1, expandAmount);
        this.strand[12].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[13].addBox(4.0f, -7.0f, 2.0f, 1, 7, 1, expandAmount);
        this.strand[13].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[14].addBox(-5.0f, -7.0f, 3.0f, 1, 8, 1, expandAmount);
        this.strand[14].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[15].addBox(4.0f, -7.0f, 3.0f, 1, 8, 1, expandAmount);
        this.strand[15].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[16].addBox(-4.0f, -7.0f, 4.0f, 1, 9, 1, expandAmount);
        this.strand[16].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[17].addBox(3.0f, -7.0f, 4.0f, 1, 9, 1, expandAmount);
        this.strand[17].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[18] = new Cube(42, 17);
        this.strand[18].addBox(-3.0f, -7.0f, 4.0f, 3, 10, 1, expandAmount);
        this.strand[18].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[19] = new Cube(43, 17);
        this.strand[19].addBox(0.0f, -7.0f, 4.0f, 3, 10, 1, expandAmount);
        this.strand[19].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[20].addBox(-1.0f, -7.0f, -5.0f, 1, 2, 1, expandAmount);
        this.strand[20].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.strand[21].addBox(0.0f, -7.0f, -5.0f, 1, 3, 1, expandAmount);
        this.strand[21].setRotationPoint(0.0f, 0.0f, 0.0f);
        this.halo = new Cube(25, 9);
        this.halo.addBox(-3.5f, -11.0f, -3.5f, 7, 0, 7, expandAmount);
        this.halo.setRotationPoint(0.0f, 0.0f, 0.0f);
    }

    public void render(float limbSwing, float limbyRot, float limbxRot, float headyRot, float headxRot, float scale) {
        int i;
        this.setupAnimation(limbSwing, limbyRot, limbxRot, headyRot, headxRot, scale);
        this.head.render(scale);
        this.body.render(scale);
        this.armRight.render(scale);
        this.armLeft.render(scale);
        this.legRight.render(scale);
        this.legLeft.render(scale);
        this.bipedBody2.render(scale);
        this.bipedRightArm2.render(scale);
        this.bipedLeftArm2.render(scale);
        this.wingLeft.render(scale);
        this.wingRight.render(scale);
        for (i = 0; i < 6; ++i) {
            this.skirt[i].render(scale);
        }
        for (i = 0; i < 22; ++i) {
            this.strand[i].render(scale);
        }
        if (LightmapHelper.isLightmapEnabled()) {
            LightmapHelper.setLightmapCoord((int)LightmapHelper.getLightmapCoord((int)15, (int)15));
        }
        this.halo.render(scale);
    }

    public void setupAnimation(float limbSwing, float limbyRot, float limbxRot, float headyRot, float headxRot, float scale) {
        Cube var10000;
        super.setupAnimation(limbSwing, limbyRot, limbxRot, headyRot, headxRot, scale);
        this.head.yRot = headyRot / 57.29578f;
        this.head.xRot = headxRot / 57.29578f;
        this.armRight.xRot = MathHelper.cos((float)(limbSwing * 0.6662f + 3.141593f)) * 2.0f * limbyRot * 0.5f;
        this.armLeft.xRot = MathHelper.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbyRot * 0.5f;
        this.armRight.zRot = 0.05f;
        this.armLeft.zRot = -0.05f;
        this.legRight.xRot = MathHelper.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbyRot;
        this.legLeft.xRot = MathHelper.cos((float)(limbSwing * 0.6662f + 3.141593f)) * 1.4f * limbyRot;
        this.legRight.yRot = 0.0f;
        this.legLeft.yRot = 0.0f;
        for (int i = 0; i < 22; ++i) {
            this.strand[i].yRot = this.head.yRot;
            this.strand[i].xRot = this.head.xRot;
        }
        this.halo.yRot = this.head.yRot;
        this.halo.xRot = this.head.xRot;
        if (this.holdingLeftHand) {
            this.armLeft.xRot = this.armLeft.xRot * 0.5f - 0.3141593f;
        }
        if (this.holdingRightHand) {
            this.armRight.xRot = this.armRight.xRot * 0.5f - 0.3141593f;
        }
        this.armRight.yRot = 0.0f;
        this.armLeft.yRot = 0.0f;
        if (this.onGround > -9990.0f) {
            float f6 = this.onGround;
            this.bipedBody2.yRot = this.body.yRot = MathHelper.sin((float)(MathHelper.sqrt((double)f6) * 3.141593f * 2.0f)) * 0.2f;
            var10000 = this.armRight;
            var10000.yRot += this.body.yRot;
            var10000 = this.armLeft;
            var10000.yRot += this.body.yRot;
            var10000 = this.armLeft;
            var10000.xRot += this.body.yRot;
            f6 = 1.0f - this.onGround;
            f6 *= f6;
            f6 *= f6;
            f6 = 1.0f - f6;
            float f7 = MathHelper.sin((float)(f6 * 3.141593f));
            float f8 = MathHelper.sin((float)(this.onGround * 3.141593f)) * -(this.head.xRot - 0.7f) * 0.75f;
            var10000 = this.armRight;
            var10000.xRot = (float)((double)var10000.xRot - ((double)f7 * 1.2 + (double)f8));
            var10000 = this.armRight;
            var10000.yRot += this.body.yRot * 2.0f;
            this.armRight.zRot = MathHelper.sin((float)(this.onGround * 3.141593f)) * -0.4f;
        }
        var10000 = this.armRight;
        var10000.zRot += MathHelper.cos((float)(limbxRot * 0.09f)) * 0.05f + 0.05f;
        var10000 = this.armLeft;
        var10000.zRot -= MathHelper.cos((float)(limbxRot * 0.09f)) * 0.05f + 0.05f;
        var10000 = this.armRight;
        var10000.xRot += MathHelper.sin((float)(limbxRot * 0.067f)) * 0.05f;
        var10000 = this.armLeft;
        var10000.xRot -= MathHelper.sin((float)(limbxRot * 0.067f)) * 0.05f;
        this.bipedRightArm2.zRot = this.armRight.zRot;
        this.bipedRightArm2.yRot = this.armRight.yRot;
        this.bipedRightArm2.xRot = this.armRight.xRot;
        this.bipedLeftArm2.zRot = this.armLeft.zRot;
        this.bipedLeftArm2.xRot = this.armLeft.xRot;
        this.wingLeft.yRot = -0.2f;
        this.wingRight.yRot = 0.2f;
        this.wingLeft.zRot = -0.125f;
        this.wingRight.zRot = 0.125f;
        var10000 = this.wingLeft;
        var10000.yRot = (float)((double)var10000.yRot + Math.sin(this.sinage) / 6.0);
        var10000 = this.wingRight;
        var10000.yRot = (float)((double)var10000.yRot - Math.sin(this.sinage) / 6.0);
        var10000 = this.wingLeft;
        var10000.zRot = (float)((double)var10000.zRot + Math.cos(this.sinage) / (double)(this.gonRound ? 8.0f : 3.0f));
        var10000 = this.wingRight;
        var10000.zRot = (float)((double)var10000.zRot - Math.cos(this.sinage) / (double)(this.gonRound ? 8.0f : 3.0f));
        this.skirt[0].xRot = -0.2f;
        this.skirt[1].xRot = -0.2f;
        this.skirt[2].xRot = 0.2f;
        this.skirt[3].xRot = 0.2f;
        this.skirt[4].zRot = 0.2f;
        this.skirt[5].zRot = -0.2f;
        if (this.legLeft.xRot < -0.3f) {
            var10000 = this.skirt[1];
            var10000.xRot += this.legLeft.xRot + 0.3f;
            var10000 = this.skirt[2];
            var10000.xRot -= this.legLeft.xRot + 0.3f;
        }
        if (this.legLeft.xRot > 0.3f) {
            var10000 = this.skirt[3];
            var10000.xRot += this.legLeft.xRot - 0.3f;
            var10000 = this.skirt[0];
            var10000.xRot -= this.legLeft.xRot - 0.3f;
        }
    }
}

