/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.projectile;

import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.Projectile;
import net.minecraft.core.net.command.TextFormatting;
import teamport.aether.AetherMod;
import teamport.aether.entity.AetherDeathMessage;
import teamport.aether.entity.boss.MobBoss;

public interface AetherProjectileDeathMessages<T extends Projectile>
extends AetherDeathMessage {
    @Override
    default public String deathMessage(Player player) {
        Projectile proj = (Projectile)this;
        Mob owner = proj.owner;
        if (owner instanceof Player) {
            Player killer = (Player)owner;
            String keys = EntityDispatcher.nameKeyForClass(proj.getClass()) + ".death_message";
            if (killer.uuid.equals(player.uuid)) {
                return TextFormatting.RED + AetherMod.TRANSLATOR.translateKey(keys + ".suicide").replace("[PLAYER]", TextFormatting.RESET + player.getDisplayName() + TextFormatting.RESET + TextFormatting.RED);
            }
            return TextFormatting.RED + AetherMod.TRANSLATOR.translateKey(keys + ".player").replace("[PLAYER]", TextFormatting.RESET + player.getDisplayName() + TextFormatting.RESET + TextFormatting.RED).replace("[KILLER]", TextFormatting.RESET + killer.getDisplayName() + TextFormatting.RESET + TextFormatting.RED);
        }
        if (owner instanceof MobBoss) {
            MobBoss boss = (MobBoss)owner;
            String bossName = EntityDispatcher.nameKeyForClass(boss.getClass()) + ".death_message";
            String projectileName = AetherMod.TRANSLATOR.translateKey(EntityDispatcher.nameKeyForClass(proj.getClass()));
            return TextFormatting.RED + AetherMod.TRANSLATOR.translateKey(bossName + "." + projectileName).replace("[PLAYER]", TextFormatting.RESET + player.getDisplayName() + TextFormatting.RESET + TextFormatting.RED).replace("[BOSS]", boss.getBossTitle());
        }
        return ((AetherDeathMessage)owner).deathMessage(player);
    }
}

