/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.items;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.tag.ITaggable;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import teamport.aether.helper.ParticleMaker;
import teamport.aether.items.AetherItems;

public class ItemBucketSkyroot
extends Item {
    @Nullable
    public final Block<?> blockToPlace;

    public ItemBucketSkyroot(String name, String namespaceId, int id, @Nullable Block<?> blockToPlace) {
        super(name, namespaceId, id);
        this.maxStackSize = 1;
        this.blockToPlace = blockToPlace;
    }

    public ItemStack onUseItem(ItemStack stack, World world, Player player) {
        int z;
        int y;
        int x;
        if (this.blockToPlace == null) {
            return new ItemStack(AetherItems.BUCKET_SKYROOT);
        }
        double reachDistance = player.getGamemode().getBlockReachDistance();
        HitResult rayTraceResult = player.rayTrace(reachDistance, 1.0f, false, false);
        if (rayTraceResult != null && rayTraceResult.hitType == HitResult.HitType.TILE && world.canMineBlock(player, x = rayTraceResult.side.getOffsetX() + rayTraceResult.x, y = rayTraceResult.side.getOffsetY() + rayTraceResult.y, z = rayTraceResult.side.getOffsetZ() + rayTraceResult.z)) {
            Block block = world.getBlock(x, y, z);
            if (block != null && !block.hasTag(BlockTags.PLACE_OVERWRITES) && !block.hasTag(BlockTags.BROKEN_BY_FLUIDS)) {
                Side side = rayTraceResult.side;
                x += side.getOffsetX();
                y += side.getOffsetY();
                z += side.getOffsetZ();
            }
            if (y >= 0 && y < world.getHeightBlocks() && (world.isAirBlock(x, y, z) || !world.getBlockMaterial(x, y, z).isSolid())) {
                if (world.dimension == Dimension.NETHER && this.blockToPlace.hasTag(BlockTags.IS_WATER)) {
                    if (world.getBlockId(x, y, z) != 0) {
                        return stack;
                    }
                    player.swingItem();
                    world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
                    for (int i = 0; i < 8; ++i) {
                        ParticleMaker.spawnParticle(world, "largesmoke", (double)x + Math.random(), (double)y + 0.2, (double)z + Math.random(), 0.0, 0.0, 0.0, 0);
                    }
                    world.setBlockWithNotify(x, y, z, 0);
                    if (player.getGamemode().consumeBlocks()) {
                        return new ItemStack(AetherItems.BUCKET_SKYROOT);
                    }
                } else {
                    if (this.blockToPlace == Blocks.FLUID_WATER_FLOWING) {
                        world.playSoundEffect((Entity)player, SoundCategory.WORLD_SOUNDS, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "liquid.splash", 0.5f, 1.0f);
                    }
                    player.swingItem();
                    Block block1 = world.getBlock(x, y, z);
                    if (block1 != null) {
                        block1.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null, null);
                    }
                    world.setBlockAndMetadataWithNotify(x, y, z, this.blockToPlace.id(), 0);
                }
                if (player.getGamemode().consumeBlocks()) {
                    return new ItemStack(AetherItems.BUCKET_SKYROOT);
                }
            }
        }
        return stack;
    }

    public void onUseByActivator(ItemStack itemStack, TileEntityActivator activatorBlock, World world, Random random, int blockX, int blockY, int blockZ, double offX, double offY, double offZ, Direction direction) {
        if (this.blockToPlace == null) {
            itemStack.itemID = AetherItems.BUCKET_SKYROOT.id;
        } else {
            int z;
            int y;
            int x = blockX + direction.getOffsetX();
            Block b = world.getBlock(x, y = blockY + direction.getOffsetY(), z = blockZ + direction.getOffsetZ());
            if (b == null || BlockTags.PLACE_OVERWRITES.appliesTo((ITaggable)b) || BlockTags.BROKEN_BY_FLUIDS.appliesTo((ITaggable)b)) {
                world.setBlockWithNotify(x, y, z, this.blockToPlace.id());
                itemStack.itemID = AetherItems.BUCKET_SKYROOT.id;
            }
        }
    }
}

