/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.item.Item;
import net.minecraft.core.util.collection.NamespaceID;
import teamport.aether.items.AetherItemTags;
import teamport.aether.items.AetherItems;
import teamport.aether.items.accessory.IAccessory;

public class LookupTrinketIcons {
    public static final LookupTrinketIcons instance = new LookupTrinketIcons();
    public final Map<NamespaceID, String> ID_OUTLINE_TEXTURES = new HashMap<NamespaceID, String>();
    public final List<String> LIST_TEXTURE = new ArrayList<String>();
    public final Set<String> SET_TEXTURES = new HashSet<String>();
    public static final Random random = new Random();

    public LookupTrinketIcons() {
        this.register();
    }

    public void register() {
        this.addEntry(AetherItems.ARMOR_TALISMAN_LEATHER.namespaceID, "aether:item/trinket/armor_pendant_outline");
        this.addEntry(AetherItems.ARMOR_TALISMAN_CHAIN.namespaceID, "aether:item/trinket/armor_pendant_outline");
        this.addEntry(AetherItems.ARMOR_TALISMAN_IRON.namespaceID, "aether:item/trinket/armor_pendant_outline");
        this.addEntry(AetherItems.ARMOR_TALISMAN_GOLD.namespaceID, "aether:item/trinket/armor_pendant_outline");
        this.addEntry(AetherItems.ARMOR_TALISMAN_DIAMOND.namespaceID, "aether:item/trinket/armor_pendant_outline");
        this.addEntry(AetherItems.ARMOR_TALISMAN_STEEL.namespaceID, "aether:item/trinket/armor_pendant_outline");
        this.addEntry(AetherItems.ARMOR_TALISMAN_ZANITE.namespaceID, "aether:item/trinket/armor_pendant_outline");
        this.addEntry(AetherItems.ARMOR_TALISMAN_GRAVITITE.namespaceID, "aether:item/trinket/armor_pendant_outline");
        this.addEntry(AetherItems.ARMOR_TALISMAN_ICE.namespaceID, "aether:item/trinket/armor_pendant_outline");
        this.addEntry(AetherItems.ARMOR_TALISMAN_REGEN.namespaceID, "aether:item/trinket/armor_stone_outline");
        this.addEntry(AetherItems.ARMOR_TALISMAN_FEATHER_GOLD.namespaceID, "aether:item/trinket/armor_feather_outline");
        this.addEntry(AetherItems.ARMOR_TALISMAN_BUBBLE.namespaceID, "aether:item/trinket/armor_bubble_outline");
        this.addEntry(AetherItems.ARMOR_SHIELD_REPULSION.namespaceID, "aether:item/trinket/armor_shield_round_outline");
    }

    public void addEntry(NamespaceID id, String texturePath) {
        this.ID_OUTLINE_TEXTURES.put(id, texturePath);
        if (this.SET_TEXTURES.contains(texturePath)) {
            return;
        }
        this.LIST_TEXTURE.add(texturePath);
    }

    @Nullable
    public String getEntry(Item item) {
        if (item instanceof IAccessory) {
            return this.ID_OUTLINE_TEXTURES.getOrDefault(item.namespaceID, null);
        }
        if (item.hasTag(AetherItemTags.TRINKET)) {
            return this.ID_OUTLINE_TEXTURES.getOrDefault(item.namespaceID, null);
        }
        return null;
    }

    public String getRandomEntry() {
        return this.LIST_TEXTURE.get(random.nextInt(this.LIST_TEXTURE.size()));
    }

    public Map<NamespaceID, String> getIDTextureMap() {
        return this.ID_OUTLINE_TEXTURES;
    }

    public List<String> getTextureList() {
        return this.LIST_TEXTURE;
    }

    public Set<String> getSET_TEXTURES() {
        return this.SET_TEXTURES;
    }
}

