/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.accessory;

import com.llamalad7.mixinextras.sugar.Local;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.entity.MobRendererPlayer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.client.render.model.ModelBiped;
import net.minecraft.client.render.model.ModelPlayer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import teamport.aether.helper.GLManager;
import teamport.aether.items.accessory.IAccessory;
import teamport.aether.items.accessory.ItemGloves;
import teamport.aether.items.accessory.pendant.ItemPendant;
import teamport.aether.items.accessory.trinket.ItemGoldenFeather;
import teamport.aether.items.accessory.trinket.ItemIronBubble;
import teamport.aether.items.accessory.trinket.ItemRegenStone;
import teamport.aether.items.accessory.trinket.ItemShield;

@Environment(value=EnvType.CLIENT)
@Mixin(value={MobRendererPlayer.class}, remap=false)
public abstract class MobRendererPlayerMixinAccessoryRender
extends MobRenderer<Player> {
    @Shadow
    private ModelBiped modelBipedMain;
    @Shadow
    @Final
    private ModelBiped modelArmor;
    @Shadow
    @Final
    private ModelBiped modelArmorChestplate;
    @Unique
    public final ModelBiped modelAccessories = new ModelBiped(1.1f);
    @Unique
    public final ModelBiped modelHeart = new ModelBiped(1.0f);
    @Unique
    public final ModelBiped modelBubble = new ModelBiped(1.0f);
    @Unique
    public final ModelBiped modelFeather = new ModelBiped(1.0f);
    @Unique
    public final ModelBiped shield = new ModelBiped(1.5f);
    @Unique
    public boolean shield_6 = false;

    @Shadow
    public abstract void render(Tessellator var1, Player var2, double var3, double var5, double var7, float var9, float var10);

    public MobRendererPlayerMixinAccessoryRender(ModelBase model, float shadowSize) {
        super(model, shadowSize);
    }

    @Inject(method={"drawFirstPersonHand"}, at={@At(value="TAIL")}, cancellable=true)
    public void callDrawFirstPersonHandAfter(@NotNull Player player, boolean isLeft, CallbackInfo ci) {
        ItemStack itemStack = player.inventory.armorInventory[4];
        if (itemStack != null && itemStack.getItem() instanceof ItemGloves) {
            Item item = itemStack.getItem();
            String path = String.format("/assets/%s/textures/armor/gloves/%s_gloves.png", item.namespaceID.namespace(), ((IAccessory)item).name());
            if (this.renderDispatcher.textureManager == null) {
                return;
            }
            this.renderDispatcher.textureManager.loadTexture(path).bind();
            this.modelArmorChestplate.onGround = 0.0f;
            this.modelArmorChestplate.isRiding = false;
            this.modelArmorChestplate.setupAnimation(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            if (this.modelBipedMain instanceof ModelPlayer) {
                if (isLeft) {
                    GL11.glDisable((int)2884);
                    this.modelArmorChestplate.armLeft.visible = true;
                    this.modelArmorChestplate.armLeft.render(0.0625f);
                } else {
                    GL11.glDisable((int)2884);
                    this.modelArmorChestplate.armRight.visible = true;
                    this.modelArmorChestplate.armRight.render(0.0625f);
                }
            }
            this.modelArmorChestplate.armLeft.visible = false;
            this.modelArmorChestplate.armRight.visible = false;
            this.modelArmorChestplate.sneaking = this.modelBipedMain.sneaking;
            this.modelArmorChestplate.holdingRightHand = this.modelBipedMain.holdingRightHand;
            this.modelArmorChestplate.holdingLeftHand = this.modelBipedMain.holdingLeftHand;
            this.modelArmorChestplate.holdingLarge = this.modelBipedMain.holdingLarge;
        }
        ci.cancel();
    }

    @ModifyArg(method={"prepareArmor*"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/player/inventory/container/ContainerInventory;armorItemInSlot(I)Lnet/minecraft/core/item/ItemStack;"))
    public int getArmorItemNotNegative(int i, @Local(argsOnly=true) int renderPass) {
        return renderPass > 3 ? renderPass : 3 - renderPass;
    }

    @Inject(method={"prepareArmor*"}, at={@At(value="TAIL")}, cancellable=true)
    public void setArmorModel(@NotNull Player player, int renderPass, float partialTick, CallbackInfoReturnable<Boolean> info) {
        float swingProgress;
        this.modelBubble.holdingLarge = this.modelHeart.holdingLarge = this.modelBipedMain.holdingLarge;
        this.modelFeather.holdingLarge = this.modelHeart.holdingLarge;
        this.shield.holdingLarge = this.modelHeart.holdingLarge;
        this.modelAccessories.holdingLarge = this.modelHeart.holdingLarge;
        this.modelBubble.holdingRightHand = this.modelHeart.holdingRightHand = this.modelBipedMain.holdingRightHand;
        this.modelFeather.holdingRightHand = this.modelHeart.holdingRightHand;
        this.shield.holdingRightHand = this.modelHeart.holdingRightHand;
        this.modelAccessories.holdingRightHand = this.modelHeart.holdingRightHand;
        this.modelBubble.holdingLeftHand = this.modelHeart.holdingLeftHand = this.modelBipedMain.holdingLeftHand;
        this.modelFeather.holdingLeftHand = this.modelHeart.holdingLeftHand;
        this.shield.holdingLeftHand = this.modelHeart.holdingLeftHand;
        this.modelAccessories.holdingLeftHand = this.modelHeart.holdingLeftHand;
        this.modelBubble.sneaking = this.modelHeart.sneaking = this.modelBipedMain.sneaking;
        this.modelFeather.sneaking = this.modelHeart.sneaking;
        this.shield.sneaking = this.modelHeart.sneaking;
        this.modelAccessories.sneaking = this.modelHeart.sneaking;
        this.modelBubble.isRiding = this.modelHeart.isRiding = this.modelBipedMain.isRiding;
        this.modelFeather.isRiding = this.modelHeart.isRiding;
        this.shield.isRiding = this.modelHeart.isRiding;
        this.modelAccessories.isRiding = this.modelHeart.isRiding;
        this.modelArmor.onGround = this.modelArmorChestplate.onGround = (swingProgress = this.getSwingProgress((Mob)player, partialTick));
        this.modelHeart.onGround = this.modelArmorChestplate.onGround;
        this.modelBubble.onGround = this.modelArmorChestplate.onGround;
        this.modelFeather.onGround = this.modelArmorChestplate.onGround;
        this.shield.onGround = this.modelArmorChestplate.onGround;
        this.modelAccessories.onGround = this.modelArmorChestplate.onGround;
        ItemStack armorStack = player.inventory.armorInventory[renderPass];
        if (armorStack != null && armorStack.getItem() instanceof IAccessory && renderPass >= 4) {
            Item item = armorStack.getItem();
            if (item instanceof ItemGloves) {
                String path = String.format("/assets/%s/textures/armor/gloves/%s_gloves.png", item.namespaceID.namespace(), ((IAccessory)item).name());
                this.modelArmorChestplate.holdingRightHand = player.inventory.getCurrentItem() != null;
                this.modelArmorChestplate.sneaking = player.isSneaking();
                this.modelArmorChestplate.isRiding = player.isPassenger();
                this.modelArmorChestplate.armLeft.visible = renderPass == 4;
                this.modelArmorChestplate.armRight.visible = renderPass == 4;
                this.renderDispatcher.textureManager.loadTexture(path).bind();
                this.setArmorModel((ModelBase)this.modelArmorChestplate);
                info.setReturnValue((Object)true);
                return;
            }
            if (item instanceof ItemShield && (renderPass == 7 || player.inventory.armorInventory[7] == null) || this.shield_6) {
                this.shield_6 = false;
                double velocity = MathHelper.sqrt((double)(player.xd * player.xd + player.zd * player.zd));
                String path = player.isSneaking() || player.onGround && velocity < 0.075 ? String.format("/assets/%s/textures/armor/energyGlow.png", item.namespaceID.namespace()) : String.format("/assets/%s/textures/armor/energyNotGlow.png", item.namespaceID.namespace());
                this.renderDispatcher.textureManager.loadTexture(path).bind();
                GLManager.glEnable(2884);
                GLManager.glEnable(3042);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glBlendFunc((int)770, (int)771);
                this.setArmorModel((ModelBase)this.shield);
                info.setReturnValue((Object)true);
                return;
            }
            if (item instanceof ItemShield && renderPass == 6) {
                this.shield_6 = true;
                ItemStack nextSlot = player.inventory.armorInventory[renderPass + 1];
                item = nextSlot.getItem();
            }
            ItemStack ItemTrinket_Slot1 = player.inventory.armorInventory[6];
            ItemStack ItemTrinket_Slot2 = player.inventory.armorInventory[7];
            if (item instanceof ItemGoldenFeather) {
                String path;
                if (renderPass == 6) {
                    path = "/assets/aether/textures/armor/trinkets/feather_gold_trinket_helmet.png";
                    this.setUPFeatherOnHelmet();
                } else {
                    path = "/assets/aether/textures/armor/trinkets/feather_gold_trinket_boots.png";
                    this.setUpFeathersOnBoots();
                }
                this.modelFeather.body.visible = false;
                this.modelFeather.armLeft.visible = false;
                this.modelFeather.armRight.visible = false;
                this.renderDispatcher.textureManager.loadTexture(path).bind();
                this.setArmorModel((ModelBase)this.modelFeather);
                info.setReturnValue((Object)true);
                return;
            }
            if (item instanceof ItemPendant) {
                int variant = 0;
                if (renderPass == 7 && ItemTrinket_Slot1 != null && ItemTrinket_Slot1.getItem() instanceof ItemPendant) {
                    variant = 1;
                }
                String path = String.format("/assets/%s/textures/armor/pendants/%s_pendant_%d.png", item.namespaceID.namespace(), ((IAccessory)item).name(), variant);
                this.modelAccessories.body.visible = true;
                this.renderDispatcher.textureManager.loadTexture(path).bind();
                this.setArmorModel((ModelBase)this.modelAccessories);
                info.setReturnValue((Object)true);
                return;
            }
            if (item instanceof ItemRegenStone) {
                String path = renderPass == 6 ? "/assets/aether/textures/armor/trinkets/regen_trinket_right.png" : "/assets/aether/textures/armor/trinkets/regen_trinket_left.png";
                this.modelHeart.head.visible = true;
                this.renderDispatcher.textureManager.loadTexture(path).bind();
                this.setArmorModel((ModelBase)this.modelHeart);
                info.setReturnValue((Object)true);
                return;
            }
            if (item instanceof ItemIronBubble) {
                boolean isInTrinketSlot2;
                boolean isInTrinketSlot1 = ItemTrinket_Slot1 != null && ItemTrinket_Slot1.getItem() instanceof ItemIronBubble;
                boolean bl = isInTrinketSlot2 = ItemTrinket_Slot2 != null && ItemTrinket_Slot2.getItem() instanceof ItemIronBubble;
                if (isInTrinketSlot1 && renderPass == 6 || isInTrinketSlot2 && !isInTrinketSlot1 && renderPass == 7) {
                    String path = "/assets/aether/textures/armor/trinkets/bubble_trinket.png";
                    this.modelBubble.head.visible = true;
                    this.modelBubble.body.visible = false;
                    this.modelBubble.armLeft.visible = false;
                    this.modelBubble.armRight.visible = false;
                    this.modelBubble.legLeft.visible = false;
                    this.modelBubble.legRight.visible = false;
                    this.renderDispatcher.textureManager.loadTexture(path).bind();
                    GLManager.glEnable(2884);
                    GLManager.glEnable(3042);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                    GL11.glBlendFunc((int)770, (int)771);
                    this.setArmorModel((ModelBase)this.modelBubble);
                    info.setReturnValue((Object)true);
                    return;
                }
            }
        }
        info.setReturnValue((Object)false);
    }

    @Unique
    private void setUPFeatherOnHelmet() {
        this.modelFeather.head.visible = true;
        this.modelFeather.legLeft.visible = false;
        this.modelFeather.legRight.visible = false;
        this.modelFeather.head.addBox(-4.0f, -12.0f, -4.0f, 8, 12, 12, 1.1f);
    }

    @Unique
    private void setUpFeathersOnBoots() {
        this.modelFeather.head.visible = false;
        this.modelFeather.legLeft.visible = true;
        this.modelFeather.legRight.visible = true;
        this.modelFeather.legLeft.addBox(-2.0f, 2.0f, -3.0f, 4, 12, 8, 1.1f);
        this.modelFeather.legRight.addBox(-2.0f, 2.0f, -3.0f, 4, 12, 8, 1.1f);
    }
}

